/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.eradicator.EradicatorEntity;

public class EradicatorNearestAttackableSensor
extends NearestLivingEntitySensor<EradicatorEntity> {
    private static final TargetingConditions TARGET_CONDITIONS = TargetingConditions.forCombat().range(32.0);
    private static final TargetingConditions TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING = TargetingConditions.forCombat().range(32.0).ignoreInvisibilityTesting();

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }

    protected void doTick(ServerLevel svlevel, EradicatorEntity entity) {
        super.doTick(svlevel, (LivingEntity)entity);
        entity.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(EntitySelector.NO_CREATIVE_OR_SPECTATOR).filter(e -> EradicatorNearestAttackableSensor.isAttackable((LivingEntity)entity, e)).findFirst().ifPresentOrElse(e -> entity.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, e), () -> entity.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }

    private static boolean isAttackable(LivingEntity attacker, LivingEntity target) {
        return attacker.getBrain().isMemoryValue(MemoryModuleType.ATTACK_TARGET, (Object)target) ? TARGET_CONDITIONS_IGNORE_INVISIBILITY_TESTING.test(attacker, target) : TARGET_CONDITIONS.test(attacker, target);
    }

    protected int radiusXZ() {
        return 32;
    }

    protected int radiusY() {
        return 32;
    }
}

