/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.handibot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import xyz.mrfrostydev.welcomeplayer.entities.ai.MeleeAttackWithHitbox;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.handibot.HandibotEntity;
import xyz.mrfrostydev.welcomeplayer.registries.SensorRegistry;

public class HandibotAI {
    protected static final ImmutableList<SensorType<? extends Sensor<? super HandibotEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, SensorRegistry.HANDIBOT_NEAREST_ATTACKABLE_SENSOR.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY);

    protected static Brain<?> makeBrain(HandibotEntity handibot, Brain<HandibotEntity> brain) {
        HandibotAI.initCoreActivity(handibot, brain);
        HandibotAI.initIdleActivity(handibot, brain);
        HandibotAI.initFightActivity(handibot, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(HandibotEntity handibot, Brain<HandibotEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90)));
    }

    private static void initIdleActivity(HandibotEntity handibot, Brain<HandibotEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.create(e -> e.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)1, (Object)StartAttacking.create(HandibotEntity::getHurtBy)), (Object)Pair.of((Object)2, (Object)new MoveToTargetSink(20, 40)), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new DoNothing(20, 100), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.5f), (Object)2))))));
    }

    private static void initFightActivity(HandibotEntity handibot, Brain<HandibotEntity> brain) {
        brain.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)StopAttackingIfTargetInvalid.create(e -> !Sensor.isEntityAttackable((LivingEntity)handibot, (LivingEntity)e))), (Object)Pair.of((Object)1, (Object)((Object)new MeleeAttackWithHitbox(40, handibot.getHitboxSets().getFirst()))), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f))), Set.of(Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    protected static void updateActivity(HandibotEntity handibot) {
        Brain<HandibotEntity> brain = handibot.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
    }
}

