/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.handibot;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.entities.EntityHitboxSet;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.handibot.HandibotAI;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;

public class HandibotEntity
extends Monster
implements GeoEntity {
    public static final double TARGETING_RANGE = 24.0;
    public static final double ATTACK_RANGE = 2.0;
    public static final int ATTACK_COOLDOWN = 40;
    boolean shouldDrop = true;
    private List<EntityHitboxSet> hitboxSets;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("handibot.animation.idle");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("handibot.animation.attack");

    public HandibotEntity(EntityType<HandibotEntity> entityType, Level level) {
        super((EntityType)EntityRegistry.HANDIBOT.get(), level);
    }

    public HandibotEntity(Level level, boolean shouldDrop) {
        super((EntityType)EntityRegistry.HANDIBOT.get(), level);
        this.shouldDrop = shouldDrop;
    }

    public void tick() {
        super.tick();
        if (this.isPassenger()) {
            this.removeVehicle();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, (double)0.32f).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR, 15.0).add(Attributes.ARMOR_TOUGHNESS, 3.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.25);
    }

    protected Brain.Provider<HandibotEntity> brainProvider() {
        return Brain.provider(HandibotAI.MEMORY_TYPES, HandibotAI.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        this.hitboxSets = this.registerHitboxSets();
        return HandibotAI.makeBrain(this, (Brain<HandibotEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<HandibotEntity> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        HandibotAI.updateActivity(this);
        super.customServerAiStep();
    }

    public Optional<LivingEntity> getHurtBy() {
        return this.getBrain().getMemory(MemoryModuleType.HURT_BY).map(DamageSource::getEntity).filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e);
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getTargetFromBrain();
    }

    public boolean canAttackType(EntityType<?> type) {
        return type == EntityType.PLAYER || type == EntityType.IRON_GOLEM;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.getBoundingBox().inflate(2.0).intersects(entity.getHitbox());
    }

    public List<EntityHitboxSet> registerHitboxSets() {
        EntityHitboxSet attackHitbox = EntityHitboxSet.Builder.create().add(EntityHitboxSet.SequenceSetBuilder.create(1.0, 0.8, 1.0, HandibotEntity::onHit).transition(1.6, 1.2, 0.0, 9)).build((Entity)this);
        return List.of(attackHitbox);
    }

    public List<EntityHitboxSet> getHitboxSets() {
        return this.hitboxSets;
    }

    private static <T extends Entity> void onHit(ServerLevel serverLevel, List<Entity> entities, T inflictor) {
        if (!(inflictor instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)inflictor;
        for (Entity target : entities) {
            if (target.is(inflictor)) continue;
            target.hurt(new DamageSource(serverLevel.registryAccess().holderOrThrow(DamageTypes.MOB_ATTACK), inflictor, inflictor), (float)livingEntity.getAttributeValue(Attributes.ATTACK_DAMAGE));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimations));
    }

    private <T extends HandibotEntity> PlayState handleAnimations(AnimationState<T> state) {
        HandibotEntity entity = (HandibotEntity)state.getAnimatable();
        if (entity.swinging) {
            state.setAnimation(ATTACK_ANIM);
        } else if (state.getController().getAnimationState() == AnimationController.State.PAUSED || state.getController().getAnimationState() == AnimationController.State.STOPPED) {
            state.setAnimation(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        ListTag hitboxesList = new ListTag();
        for (EntityHitboxSet set : this.hitboxSets) {
            hitboxesList.add((Object)set.saveData());
        }
        tag.put("hitboxSets", (Tag)hitboxesList);
        tag.putBoolean("shouldDrop", this.shouldDrop);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        ListTag hitboxesList = tag.getList("hitboxSets", (int)tag.getTagType("hitboxSets"));
        for (int i = 0; i < this.hitboxSets.size(); ++i) {
            EntityHitboxSet set = this.hitboxSets.get(i);
            set.loadData(hitboxesList.getCompound(i));
        }
        this.shouldDrop = tag.getBoolean("shouldDrop");
    }

    protected boolean shouldDropLoot() {
        return this.shouldDrop;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public int getHeadRotSpeed() {
        return 25;
    }
}

