/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.service_bot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.service_bot.ServiceBotEntity;

public class ServiceBotAI {
    protected static final ImmutableList<SensorType<? extends Sensor<? super ServiceBotEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);

    protected static Brain<?> makeBrain(ServiceBotEntity owner, Brain<ServiceBotEntity> brain) {
        ServiceBotAI.initCoreActivity(owner, brain);
        ServiceBotAI.initIdleActivity(owner, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(ServiceBotEntity owner, Brain<ServiceBotEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90)));
    }

    private static void initIdleActivity(ServiceBotEntity owner, Brain<ServiceBotEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f)), (Object)Pair.of((Object)1, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)2, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)new DoNothing(20, 100), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f), (Object)3))))));
    }

    protected static void updateActivity(ServiceBotEntity owner) {
        Brain<ServiceBotEntity> brain = owner.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE));
    }
}

