/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.mobs.service_bot;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.entities.ai.navigation.HoverPathNavigation;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.service_bot.ServiceBotAI;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;

public class ServiceBotEntity
extends PathfinderMob
implements GeoEntity {
    public static final double TARGETING_RANGE = 20.0;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("service_bot.animation.idle");

    public ServiceBotEntity(EntityType<ServiceBotEntity> entityType, Level level) {
        super((EntityType)EntityRegistry.SERVICE_BOT.get(), level);
    }

    public void tick() {
        super.tick();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ARMOR, 10.0).add(Attributes.ARMOR_TOUGHNESS, 1.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 0.0);
    }

    protected Brain.Provider<ServiceBotEntity> brainProvider() {
        return Brain.provider(ServiceBotAI.MEMORY_TYPES, ServiceBotAI.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return ServiceBotAI.makeBrain(this, (Brain<ServiceBotEntity>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<ServiceBotEntity> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        ServiceBotAI.updateActivity(this);
        super.customServerAiStep();
    }

    public Optional<LivingEntity> getHurtBy() {
        return this.getBrain().getMemory(MemoryModuleType.HURT_BY).map(DamageSource::getEntity).filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e);
    }

    protected PathNavigation createNavigation(Level level) {
        return new HoverPathNavigation((Mob)this, level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimations));
    }

    private <T extends ServiceBotEntity> PlayState handleAnimations(AnimationState<T> state) {
        if ((state.getController().getAnimationState() == AnimationController.State.PAUSED || state.getController().getAnimationState() == AnimationController.State.STOPPED) && this.level().random.nextInt(200) == 0) {
            state.resetCurrentAnimation();
            state.setAnimation(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public static boolean checkServiceBotSpawnRules(EntityType<ServiceBotEntity> serviceBot, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AudienceUtil.isActive(levelAccessor.getLevel());
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    public int getMaxHeadYRot() {
        return 30;
    }

    public int getHeadRotSpeed() {
        return 25;
    }
}

