/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.projectiles;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ParticleRegistry;

public class SeismicBlastProjectile
extends Projectile {
    private static final float BLAST_COOLDOWN = 5.0f;
    private static final int DURATION = 50;
    private int lifetime = 50;

    public SeismicBlastProjectile(EntityType<? extends SeismicBlastProjectile> entityType, Level level) {
        super((EntityType)EntityRegistry.SEISMIC_BLAST_PROJECTILE.get(), level);
    }

    public SeismicBlastProjectile(Level level, @Nullable Entity owner, double x, double y, double z) {
        super((EntityType)EntityRegistry.SEISMIC_BLAST_PROJECTILE.get(), level);
        this.setOwner(owner);
        this.setPos(x, y, z);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        this.setDeltaMovement(new Vec3(x, y, z).normalize().scale((double)velocity));
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            this.explode();
        }
    }

    protected void explode() {
        BlockState block = Blocks.COARSE_DIRT.defaultBlockState();
        this.level().explode(this.getOwner(), null, (ExplosionDamageCalculator)new SeismicExplosionDamagerCalculator(false, true, Optional.of(Float.valueOf(3.0f)), Optional.empty()), this.getX(), this.getY(), this.getZ(), 3.5f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), (Holder)SoundEvents.WIND_CHARGE_BURST);
        for (int i = 0; i < 40; ++i) {
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, block), this.getRandomX(3.0), this.getRandomY() - 0.7, this.getRandomZ(3.0), 0.0, 0.0, 0.0);
        }
        this.level().addParticle((ParticleOptions)ParticleRegistry.SEISMIC_BLAST.get(), this.getX(), this.getY() + 0.4, this.getZ(), 0.0, 0.0, 0.0);
    }

    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxBuildHeight() + 30) {
            this.explode();
            this.discard();
            return;
        }
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.explode();
            this.discard();
            return;
        }
        if (this.level().isClientSide || this.level().hasChunkAt(this.blockPosition())) {
            super.tick();
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity, (ClipContext.Block)ClipContext.Block.COLLIDER);
            if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.onHit(hitresult);
            }
            this.checkInsideBlocks();
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = this.getX() + vec3.x;
            double d1 = this.getY() + vec3.y;
            double d2 = this.getZ() + vec3.z;
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
            this.setXRot(SeismicBlastProjectile.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(SeismicBlastProjectile.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.setPos(d0, d1, d2);
            if ((float)this.lifetime % 5.0f == 0.0f) {
                this.explode();
            }
        } else {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            this.explode();
            this.discard();
        }
    }

    protected boolean canHitEntity(Entity target) {
        return false;
    }

    protected AABB makeBoundingBox() {
        float f = this.getType().getDimensions().width() / 2.0f;
        float f1 = this.getType().getDimensions().height();
        float f2 = 0.15f;
        return new AABB(this.position().x - (double)f, this.position().y - (double)0.15f, this.position().z - (double)f, this.position().x + (double)f, this.position().y - (double)0.15f + (double)f1, this.position().z + (double)f);
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_entity) {
        Entity entity = this.getOwner();
        int i = entity == null ? 0 : entity.getId();
        Vec3 vec3 = p_entity.getPositionBase();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), vec3.x(), vec3.y(), vec3.z(), p_entity.getLastSentXRot(), p_entity.getLastSentYRot(), this.getType(), i, p_entity.getLastSentMovement(), 0.0);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Vec3 vec3 = new Vec3(packet.getXa(), packet.getYa(), packet.getZa());
        this.setDeltaMovement(vec3);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("lifetime", this.lifetime);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.lifetime = tag.getInt("lifetime");
    }

    public static class SeismicExplosionDamagerCalculator
    extends SimpleExplosionDamageCalculator {
        public SeismicExplosionDamagerCalculator(boolean explodesBlocks, boolean damagesEntities, Optional<Float> knockbackMultiplier, Optional<HolderSet<Block>> immuneBlocks) {
            super(explodesBlocks, damagesEntities, knockbackMultiplier, immuneBlocks);
        }

        public float getEntityDamageAmount(Explosion explosion, Entity entity) {
            float f = explosion.radius() * 2.0f;
            Vec3 vec3 = explosion.center();
            double distFromExplosion = Math.sqrt(entity.distanceToSqr(vec3)) / (double)f;
            double damage = (1.0 - distFromExplosion) * (double)Explosion.getSeenPercent((Vec3)vec3, (Entity)entity);
            return (float)((damage * damage + damage) / 2.0 * (double)f + 1.0);
        }
    }
}

