/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.projectiles;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

public class ShockBoltProjectile
extends Projectile
implements GeoEntity {
    private int lifetime;
    private static final EntityDataAccessor<Integer> DATA_LENGTH = SynchedEntityData.defineId(ShockBoltProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ShockBoltProjectile(EntityType<? extends ShockBoltProjectile> entityType, Level level) {
        super((EntityType)EntityRegistry.SHOCK_BOLT_PROJECTILE.get(), level);
        this.lifetime = 4;
    }

    public ShockBoltProjectile(Level level, Entity owner, Vec3 originPos, Vec3 targetPos) {
        super((EntityType)EntityRegistry.SHOCK_BOLT_PROJECTILE.get(), level);
        this.setOwner(owner);
        this.lifetime = 4;
        double targetVecX = targetPos.x - originPos.x;
        double targetVecY = targetPos.y - originPos.y;
        double targetVecZ = targetPos.z - originPos.z;
        this.setPos(originPos.x + targetVecX / 2.0, originPos.y + targetVecY / 2.0, originPos.z + targetVecZ / 2.0);
        this.setDeltaMovement(new Vec3(targetVecX, targetVecY, targetVecZ).normalize());
        double dist = originPos.distanceTo(targetPos);
        int length = 0;
        if (dist > 2.5) {
            length = 3;
        } else if (dist < 1.5) {
            length = 2;
        }
        this.entityData.set(DATA_LENGTH, (Object)length);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void tick() {
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.discard();
            return;
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity, (ClipContext.Block)ClipContext.Block.COLLIDER);
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.setXRot(ShockBoltProjectile.lerpRotation(this.xRotO, this.getXRot()));
        this.setYRot(ShockBoltProjectile.lerpRotation(this.yRotO, this.getYRot()));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        if (this.lifetime == 3) {
            this.playSound((SoundEvent)SoundEventRegistry.SHOCK_ZAP.get(), 1.0f, 0.8f + this.level().random.nextFloat() * 0.2f);
        }
        super.tick();
    }

    protected static float lerpRotation(float currentRotation, float targetRotation) {
        while (targetRotation - currentRotation < -180.0f) {
            currentRotation -= 360.0f;
        }
        while (targetRotation - currentRotation >= 180.0f) {
            currentRotation += 360.0f;
        }
        return Mth.lerp((float)0.9f, (float)currentRotation, (float)targetRotation);
    }

    public int getLength() {
        return (Integer)this.entityData.get(DATA_LENGTH);
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    protected boolean canHitEntity(Entity target) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_LENGTH, (Object)0);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_entity) {
        Entity entity = this.getOwner();
        int i = entity == null ? 0 : entity.getId();
        Vec3 vec3 = p_entity.getPositionBase();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), vec3.x(), vec3.y(), vec3.z(), p_entity.getLastSentXRot(), p_entity.getLastSentYRot(), this.getType(), i, p_entity.getLastSentMovement(), 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Vec3 vec3 = new Vec3(packet.getXa(), packet.getYa(), packet.getZa());
        this.setDeltaMovement(vec3);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

