/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.entities.projectiles;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.damages.LaserDamageSource;
import xyz.mrfrostydev.welcomeplayer.damages.ShockDamageSource;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.ModDamageTypes;
import xyz.mrfrostydev.welcomeplayer.entities.projectiles.ShockBoltProjectile;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ParticleRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

public class ShockChargeProjectile
extends Projectile
implements GeoEntity {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(false, true, Optional.empty(), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    private static final float SHOCK_RANGE = 3.0f;
    private static final float SHOCK_DAMAGE = 5.0f;
    private static final float TICK_COOLDOWN = 10.0f;
    private int lifetime;
    private boolean isUnstable;
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ShockChargeProjectile(EntityType<? extends ShockChargeProjectile> entityType, Level level) {
        super((EntityType)EntityRegistry.SHOCK_CHARGE_PROJECTILE.get(), level);
        this.lifetime = 400;
    }

    public ShockChargeProjectile(Level level, @Nullable Entity owner, double x, double y, double z, int lifetime, boolean isUnstable) {
        super((EntityType)EntityRegistry.SHOCK_CHARGE_PROJECTILE.get(), level);
        this.lifetime = lifetime;
        this.isUnstable = isUnstable;
        this.setOwner(owner);
        this.setPos(x, y, z);
    }

    public ShockChargeProjectile(Level level, @Nullable Entity owner, double x, double y, double z, boolean isUnstable) {
        super((EntityType)EntityRegistry.SHOCK_CHARGE_PROJECTILE.get(), level);
        this.lifetime = 400;
        this.isUnstable = isUnstable;
        this.setOwner(owner);
        this.setPos(x, y, z);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        this.setDeltaMovement(new Vec3(x, y, z).normalize().scale((double)velocity));
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide) {
            ShockDamageSource damagesource;
            LivingEntity livingentity1;
            Entity entity = this.getOwner();
            LivingEntity livingentity = entity instanceof LivingEntity ? (livingentity1 = (LivingEntity)entity) : null;
            Entity entity2 = result.getEntity();
            if (livingentity != null) {
                livingentity.setLastHurtMob(entity2);
            }
            if (entity2.hurt((DamageSource)(damagesource = new ShockDamageSource((Holder<DamageType>)this.level().registryAccess().holderOrThrow(ModDamageTypes.SHOCK), this.getOwner())), 12.0f) && entity2 instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)target, (DamageSource)damagesource);
            }
            this.explode(this.position());
        }
    }

    protected void explode(Vec3 pos) {
        this.level().explode(this.getOwner(), (DamageSource)new LaserDamageSource((Holder<DamageType>)this.level().registryAccess().holderOrThrow(ModDamageTypes.SHOCK), this.getOwner()), EXPLOSION_DAMAGE_CALCULATOR, pos.x(), pos.y(), pos.z(), 2.5f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.GLOW, (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel svlevel = (ServerLevel)level;
            svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.SHOCK_BLAST.get()), pos.x, pos.y + 0.3, pos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxBuildHeight() + 30) {
            this.explode(this.position());
            this.discard();
            return;
        }
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.explode(this.position());
            this.discard();
            return;
        }
        Entity entity = this.getOwner();
        if (this.level().isClientSide || (entity == null || !entity.isRemoved()) && this.level().hasChunkAt(this.blockPosition())) {
            super.tick();
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity, (ClipContext.Block)ClipContext.Block.COLLIDER);
            if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.hitTargetOrDeflectSelf(hitresult);
            }
            this.checkInsideBlocks();
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = this.getX() + vec3.x;
            double d1 = this.getY() + vec3.y;
            double d2 = this.getZ() + vec3.z;
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
                }
            }
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
            this.setXRot(ShockChargeProjectile.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(ShockChargeProjectile.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.setPos(d0, d1, d2);
            if ((float)this.lifetime % 10.0f == 0.0f) {
                double x = this.position().x;
                double y = this.position().y;
                double z = this.position().z;
                AABB area = new AABB(x, y, z, x, y, z).inflate(3.0);
                List entities = this.level().getEntities(this.getOwner(), area, this.isUnstable ? e -> !e.isSpectator() : e -> !e.getType().equals(EntityType.PLAYER) && (!(e instanceof TamableAnimal) || ((TamableAnimal)e).getOwner() == null) && !e.isSpectator());
                for (Entity e2 : entities) {
                    if (!(e2 instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)e2;
                    Vec3 shootPos = new Vec3(x, y, z);
                    ShockBoltProjectile shockBolt = new ShockBoltProjectile(this.level(), this.getOwner(), shootPos, new Vec3(e2.getX(), e2.getEyeY() - 0.2, e2.getZ()));
                    this.level().addFreshEntity((Entity)shockBolt);
                    target.hurt((DamageSource)new ShockDamageSource((Holder<DamageType>)this.level().registryAccess().holderOrThrow(ModDamageTypes.SHOCK), this.getOwner()), 5.0f);
                    if (this.level().isClientSide) continue;
                    LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                    lightning.setDamage(0.0f);
                    target.thunderHit((ServerLevel)this.level(), lightning);
                }
            }
            if (this.lifetime % 2 == 0) {
                this.level().addParticle((ParticleOptions)ParticleRegistry.ORB_TRAIL.get(), d0, d1, d2, 0.0, 0.0, 0.0);
            }
            if (this.lifetime % 16 == 0) {
                this.playSound((SoundEvent)SoundEventRegistry.SHOCK_HUM.get(), 0.8f, 1.0f);
            }
        } else {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide) {
            Vec3i vec3i = result.getDirection().getNormal();
            Vec3 vec3 = Vec3.atLowerCornerOf((Vec3i)vec3i).multiply(0.25, 0.25, 0.25);
            Vec3 vec31 = result.getLocation().add(vec3);
            this.explode(vec31);
            this.discard();
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    protected boolean canHitEntity(Entity target) {
        return this.getOwner() == null || !this.getOwner().is(target);
    }

    protected AABB makeBoundingBox() {
        float f = this.getType().getDimensions().width() / 2.0f;
        float f1 = this.getType().getDimensions().height();
        float f2 = 0.15f;
        return new AABB(this.position().x - (double)f, this.position().y - (double)0.15f, this.position().z - (double)f, this.position().x + (double)f, this.position().y - (double)0.15f + (double)f1, this.position().z + (double)f);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_entity) {
        Entity entity = this.getOwner();
        int i = entity == null ? 0 : entity.getId();
        Vec3 vec3 = p_entity.getPositionBase();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), vec3.x(), vec3.y(), vec3.z(), p_entity.getLastSentXRot(), p_entity.getLastSentYRot(), this.getType(), i, p_entity.getLastSentMovement(), 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Vec3 vec3 = new Vec3(packet.getXa(), packet.getYa(), packet.getZa());
        this.setDeltaMovement(vec3);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("lifetime", this.lifetime);
        tag.putBoolean("isUnstable", this.isUnstable);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.lifetime = tag.getInt("lifetime");
        this.isUnstable = tag.getBoolean("isUnstable");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

