/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.ObjectiveManagerData;
import xyz.mrfrostydev.welcomeplayer.data.VendorShopData;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;
import xyz.mrfrostydev.welcomeplayer.utils.VendorUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class ServerStartEvents {
    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        ServerLevel svlevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (svlevel = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            DimensionDataStorage dataStorage = svlevel.getDataStorage();
            if (dataStorage.get(AudienceData.factory(), "audience_data") == null) {
                AudienceUtil.computeAudienceData(svlevel);
            }
            if (dataStorage.get(ObjectiveManagerData.factory(), "objective_manager_data") == null) {
                ObjectiveUtil.computeObjectiveManagerData(svlevel);
            }
            if (dataStorage.get(VendorShopData.factory(), "vendor_data") == null) {
                VendorUtil.computeVendorData(svlevel);
            }
        }
    }
}

