/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers;

import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.network.SyncAudienceDataSmallPacket;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceEventUtil;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;
import xyz.mrfrostydev.welcomeplayer.utils.VendorUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class WorldTickEvents {
    public static final int TICK_COOLDOWN = 200;
    public static final int MOOD_CHANGE_COOLDOWN = 12000;

    @SubscribeEvent
    public static void onWorldTickPost(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        List playerList = event.getLevel().players().stream().toList();
        int levelTickCount = event.getLevel().getServer().getTickCount();
        VendorUtil.doTick(svlevel);
        if (!AudienceUtil.isActive(svlevel)) {
            return;
        }
        AudienceUtil.doTick(svlevel);
        ObjectiveUtil.doTick(svlevel);
        if (levelTickCount % 200 == 0) {
            AudienceData data = AudienceUtil.getAudienceData(svlevel);
            AudienceUtil.addInterestRaw(svlevel, -1);
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)SyncAudienceDataSmallPacket.create(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (AudienceUtil.isPhaseShifting(svlevel) && !AudienceUtil.isChangeCooldown(svlevel)) {
                AudienceUtil.pickMood(svlevel);
                AudienceEventUtil.pickEvent(svlevel);
                AudienceUtil.restartPhaseShift(svlevel);
                AudienceUtil.startChangeCooldown(svlevel);
                AudienceUtil.syncToClients(svlevel);
            }
        }
        if (levelTickCount % 12000 == 0 && !AudienceUtil.isChangeCooldown(svlevel)) {
            AudienceUtil.pickMood(svlevel);
            AudienceEventUtil.pickEvent(svlevel);
            AudienceUtil.startChangeCooldown(svlevel);
            AudienceUtil.syncToClients(svlevel);
        }
        if (levelTickCount % 1000 == 0 && ObjectiveUtil.getGoingObjective(svlevel).is(PlayerObjective.NOTHING)) {
            ObjectiveUtil.pickObjective(svlevel);
        }
    }
}

