/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers.events;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.AudienceEvents;
import xyz.mrfrostydev.welcomeplayer.registries.DataAttachmentRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ParticleRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceEventUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class EventDamageEvents {
    @SubscribeEvent
    public static void onEntityDamageShield(LivingIncomingDamageEvent event) {
        int remainingShield;
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        if (event.getSource().getEntity() == null) {
            return;
        }
        if (event.getEntity().getType().equals(EntityType.PLAYER)) {
            return;
        }
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        AudienceEvent goingEvent = AudienceEventUtil.getGoingEvent(svlevel);
        if (goingEvent.is(AudienceEvents.BACKUP_SAFETY) && !victim.hasData((AttachmentType)DataAttachmentRegistry.DAMAGE_SHIELD.get())) {
            victim.setData((AttachmentType)DataAttachmentRegistry.DAMAGE_SHIELD.get(), (Object)3);
        }
        if (victim.hasData((AttachmentType)DataAttachmentRegistry.DAMAGE_SHIELD.get()) && (remainingShield = ((Integer)victim.getData(DataAttachmentRegistry.DAMAGE_SHIELD)).intValue()) > 0) {
            victim.setData((AttachmentType)DataAttachmentRegistry.DAMAGE_SHIELD.get(), (Object)(remainingShield - 1));
            svlevel.playSound(null, victim.getX(), victim.getEyeY(), victim.getZ(), (SoundEvent)SoundEventRegistry.SHIELD_HIT.get(), SoundSource.NEUTRAL, 1.0f, svlevel.random.nextFloat() * 0.4f + 0.8f);
            if (attacker != null) {
                double victimHeightHalf = victim.getBbHeight() / 2.0f;
                Vec3 vecDir = attacker.getEyePosition().subtract(victim.position()).normalize().scale(1.2);
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.SHIELD_HIT.get()), victim.getX() + vecDir.x, victim.getY() + vecDir.y + victimHeightHalf, victim.getZ() + vecDir.z, 1, 0.0, 0.0, 0.0, 0.0);
            } else {
                svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.SHIELD_HIT.get()), victim.getX(), victim.getEyeY() - 0.2, victim.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityDamageRepulsion(LivingIncomingDamageEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        if (event.getSource().getEntity() == null) {
            return;
        }
        if (event.getEntity().getType().equals(EntityType.PLAYER)) {
            return;
        }
        LivingEntity victim = event.getEntity();
        AudienceEvent goingEvent = AudienceEventUtil.getGoingEvent(svlevel);
        if (goingEvent.is(AudienceEvents.REPULSION_TECH)) {
            int cooldown;
            if (!victim.hasData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get())) {
                victim.setData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get(), (Object)0);
            }
            if ((cooldown = ((Integer)victim.getData(DataAttachmentRegistry.REPULSION_COOLDOWN)).intValue()) <= 0) {
                victim.setData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get(), (Object)5);
                svlevel.explode((Entity)victim, null, (ExplosionDamageCalculator)new SimpleExplosionDamageCalculator(false, false, Optional.of(Float.valueOf(2.0f)), Optional.empty()), victim.getX(), victim.getY() + (double)(victim.getBbHeight() / 2.0f), victim.getZ(), 4.0f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleRegistry.SHOCK_BLAST.get(), (ParticleOptions)ParticleRegistry.SHOCK_BLAST.get(), (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST);
                svlevel.playSound(null, victim.getX(), victim.getEyeY(), victim.getZ(), (Holder)SoundEvents.BREEZE_WIND_CHARGE_BURST, SoundSource.NEUTRAL, 1.0f, svlevel.random.nextFloat() * 0.4f + 0.8f);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityKnockbackPropulsion(LivingKnockBackEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        AudienceEvent goingEvent = AudienceEventUtil.getGoingEvent(svlevel);
        if (goingEvent.is(AudienceEvents.PROPULSION_UPGRADE)) {
            event.setStrength(event.getOriginalStrength() * 4.0f);
        }
    }
}

