/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers.events;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.AudienceEvents;
import xyz.mrfrostydev.welcomeplayer.entities.projectiles.ShockChargeProjectile;
import xyz.mrfrostydev.welcomeplayer.registries.TagRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceEventUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class EventKillEvents {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        if (event.getSource().getEntity() == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        AudienceEvent goingEvent = AudienceEventUtil.getGoingEvent(svlevel);
        if (entity.getType().is(TagRegistry.HOST_ROBOT) && goingEvent.is(AudienceEvents.DESTRUCT_PROTOCOL)) {
            float power = 1.8f * (float)Math.log10(entity.getMaxHealth() + 1.0f);
            svlevel.explode((Entity)entity, Explosion.getDefaultDamageSource((Level)entity.level(), (Entity)entity), null, entity.getX(), entity.getY() + 0.4, entity.getZ(), power, true, Level.ExplosionInteraction.MOB, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION, (Holder)SoundEvents.GENERIC_EXPLODE);
            svlevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, entity.getX(), entity.getY() + 0.4, entity.getZ(), 4, 0.8, 0.8, 0.8, 0.0);
        } else if (goingEvent.is(AudienceEvents.ELECTRIC_SOUL)) {
            ShockChargeProjectile shock = new ShockChargeProjectile((Level)svlevel, null, entity.getX(), entity.getEyeY(), entity.getZ(), 100, true);
            svlevel.addFreshEntity((Entity)shock);
        }
    }
}

