/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers.events;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.AudienceEvents;
import xyz.mrfrostydev.welcomeplayer.events.AudienceEventStartedEvent;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;

@EventBusSubscriber(modid="welcomeplayer")
public class EventSummonEvents {
    @SubscribeEvent
    public static void onEventStart(AudienceEventStartedEvent event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        AudienceEvent startedEvent = event.getStartedEvent();
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.ZOMBIE_HORDE, EntityType.ZOMBIE, 12)) {
            return;
        }
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.FAST_FOOD, EntityType.CHICKEN, 5)) {
            return;
        }
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.FAST_SERVICE, (EntityType)EntityRegistry.SERVICE_BOT.get(), 3)) {
            return;
        }
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.ROBOT_PATROL, (EntityType)EntityRegistry.HANDIBOT.get(), 4)) {
            return;
        }
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.BOMB_SQUAD, EntityType.CREEPER, 5)) {
            return;
        }
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.ROARING_THUNDER, EntityType.DROWNED, 8)) {
            return;
        }
        if (EventSummonEvents.spawnForEvent(svlevel, startedEvent, AudienceEvents.DESTRUCT_PROTOCOL, (EntityType)EntityRegistry.HANDIBOT.get(), 2)) {
            return;
        }
        if (EventSummonEvents.spawnForEventSinglePlayer(svlevel, startedEvent, AudienceEvents.BIG_BOSS, (EntityType)EntityRegistry.ERADICATOR.get(), 1)) {
            return;
        }
        if (startedEvent.is(AudienceEvents.NUCLEAR_SQUAD)) {
            EventSummonEvents.attemptSpawnWithModification(svlevel, EntityType.CREEPER, 4, e -> {
                if (e instanceof Creeper) {
                    LightningBolt lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)svlevel);
                    lightning.setDamage(0.0f);
                    e.thunderHit(svlevel, lightning);
                }
            });
        }
    }

    private static boolean spawnForEvent(ServerLevel svlevel, AudienceEvent startedEvent, AudienceEvents.AudienceEventType eventType, EntityType<?> entityType, int amount) {
        boolean isTrue = startedEvent.is(eventType);
        if (isTrue) {
            EventSummonEvents.attemptSpawn(svlevel, entityType, amount);
        }
        return isTrue;
    }

    private static boolean spawnForEventSinglePlayer(ServerLevel svlevel, AudienceEvent startedEvent, AudienceEvents.AudienceEventType eventType, EntityType<?> entityType, int amount) {
        boolean isTrue = startedEvent.is(eventType);
        if (isTrue) {
            EventSummonEvents.attemptSpawnSinglePlayer(svlevel, entityType, amount);
        }
        return isTrue;
    }

    private static void attemptSpawn(ServerLevel svlevel, EntityType<?> entityType, int amount) {
        List players = svlevel.getPlayers(p -> !p.isSpectator());
        for (ServerPlayer player : players) {
            int offset = 0;
            for (int i = 0; i < amount; ++i) {
                Entity entity;
                BlockPos pos = EventSummonEvents.findRandomSpawnPos(svlevel, player.getOnPos(), offset, 30);
                if (pos == null) {
                    pos = player.getOnPos();
                }
                if ((entity = entityType.create((Level)svlevel)) == null) continue;
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                svlevel.addFreshEntity(entity);
                ++offset;
            }
        }
    }

    private static void attemptSpawnWithModification(ServerLevel svlevel, EntityType<?> entityType, int amount, Consumer<Entity> modification) {
        List players = svlevel.getPlayers(p -> !p.isSpectator());
        for (ServerPlayer player : players) {
            int offset = 0;
            for (int i = 0; i < amount; ++i) {
                Entity entity;
                BlockPos pos = EventSummonEvents.findRandomSpawnPos(svlevel, player.getOnPos(), offset, 30);
                if (pos == null) {
                    pos = player.getOnPos();
                }
                if ((entity = entityType.create((Level)svlevel)) == null) continue;
                modification.accept(entity);
                entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
                svlevel.addFreshEntity(entity);
                ++offset;
            }
        }
    }

    private static void attemptSpawnSinglePlayer(ServerLevel svlevel, EntityType<?> entityType, int amount) {
        List players = svlevel.getPlayers(p -> !p.isSpectator());
        Collections.shuffle(players);
        ServerPlayer player = (ServerPlayer)players.getFirst();
        for (int i = 0; i < amount; ++i) {
            Entity entity;
            BlockPos pos = EventSummonEvents.findRandomSpawnPos(svlevel, player.getOnPos(), 0, 30);
            if (pos == null) {
                pos = player.getOnPos();
            }
            if ((entity = entityType.create((Level)svlevel)) == null) continue;
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            svlevel.addFreshEntity(entity);
        }
    }

    @Nullable
    private static BlockPos findRandomSpawnPos(ServerLevel svlevel, BlockPos targetPos, int offsetMultiplier, int maxTry) {
        int i = offsetMultiplier == 0 ? 2 : 2 - offsetMultiplier;
        BlockPos.MutableBlockPos pPos = new BlockPos.MutableBlockPos();
        SpawnPlacementType spawnplacementtype = SpawnPlacements.getPlacementType((EntityType)EntityType.RAVAGER);
        for (int i1 = 0; i1 < maxTry; ++i1) {
            float f = svlevel.random.nextFloat() * ((float)Math.PI * 2);
            int j = targetPos.getX() + Mth.floor((float)(Mth.cos((float)f) * 12.0f * (float)i)) + svlevel.random.nextInt(6);
            int l = targetPos.getZ() + Mth.floor((float)(Mth.sin((float)f) * 12.0f * (float)i)) + svlevel.random.nextInt(6);
            int k = svlevel.getHeight(Heightmap.Types.WORLD_SURFACE, j, l);
            pPos.set(j, k, l);
            if (!svlevel.hasChunksAt(pPos.getX() - 10, pPos.getZ() - 10, pPos.getX() + 10, pPos.getZ() + 10) || !svlevel.isPositionEntityTicking((BlockPos)pPos) || !spawnplacementtype.isSpawnPositionOk((LevelReader)svlevel, (BlockPos)pPos, EntityType.RAVAGER) && (!svlevel.getBlockState(pPos.below()).is(Blocks.SNOW) || !svlevel.getBlockState((BlockPos)pPos).isAir())) continue;
            return pPos;
        }
        return null;
    }
}

