/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers.events;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.AudienceEvents;
import xyz.mrfrostydev.welcomeplayer.entities.mobs.handibot.HandibotEntity;
import xyz.mrfrostydev.welcomeplayer.registries.DataAttachmentRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.TagRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceEventUtil;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class EventTickEvents {
    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        AudienceEvent goingEvent = AudienceEventUtil.getGoingEvent(svlevel);
        int levelTickCount = svlevel.getServer().getTickCount();
        EventTickEvents.handleContraband(svlevel, goingEvent, levelTickCount);
    }

    @SubscribeEvent
    public static void onTickEntity(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        int tick = event.getEntity().tickCount;
        if (tick % 20 == 0 && entity.hasData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get())) {
            int cooldown = (Integer)entity.getData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get());
            if (cooldown > 0) {
                entity.setData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get(), (Object)(cooldown - 1));
            } else {
                entity.removeData((AttachmentType)DataAttachmentRegistry.REPULSION_COOLDOWN.get());
            }
        }
    }

    private static void handleContraband(ServerLevel svlevel, AudienceEvent goingEvent, int tick) {
        if (tick % 400 == 0 && goingEvent.is(AudienceEvents.CONTRABAND)) {
            svlevel.players().forEach(p -> {
                if (p.isHolding(i -> i.is(TagRegistry.CONTRABAND) && EventTickEvents.canBeSeenOnSurface(svlevel, (Player)p))) {
                    int offset = 0;
                    for (int i2 = 0; i2 < 5; ++i2) {
                        BlockPos pos = EventTickEvents.findRandomSpawnPos(svlevel, p.getOnPos(), offset, 20);
                        if (pos == null) {
                            pos = p.getOnPos();
                        }
                        HandibotEntity bot = new HandibotEntity((Level)svlevel, false);
                        bot.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
                        bot.setTarget((LivingEntity)p);
                        bot.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, p);
                        svlevel.addFreshEntity((Entity)bot);
                        ++offset;
                    }
                    svlevel.playSound(null, p.getX(), p.getEyeY(), p.getZ(), (SoundEvent)SoundEventRegistry.CONTRABAND_SIREN.get(), SoundSource.NEUTRAL, 1.0f, svlevel.random.nextFloat() * 0.4f + 0.8f);
                    AudienceUtil.sendDialog((Component)Component.translatable((String)"dialog.welcomeplayer.event.contraband.caught"), p);
                }
            });
        }
    }

    @Nullable
    private static BlockPos findRandomSpawnPos(ServerLevel svlevel, BlockPos targetPos, int offsetMultiplier, int maxTry) {
        int i = offsetMultiplier == 0 ? 2 : 2 - offsetMultiplier;
        BlockPos.MutableBlockPos pPos = new BlockPos.MutableBlockPos();
        SpawnPlacementType spawnplacementtype = SpawnPlacements.getPlacementType((EntityType)EntityType.RAVAGER);
        for (int i1 = 0; i1 < maxTry; ++i1) {
            float f = svlevel.random.nextFloat() * ((float)Math.PI * 2);
            int j = targetPos.getX() + Mth.floor((float)(Mth.cos((float)f) * 10.0f * (float)i)) + svlevel.random.nextInt(6);
            int l = targetPos.getZ() + Mth.floor((float)(Mth.sin((float)f) * 10.0f * (float)i)) + svlevel.random.nextInt(6);
            int k = svlevel.getHeight(Heightmap.Types.WORLD_SURFACE, j, l);
            pPos.set(j, k, l);
            if (!svlevel.hasChunksAt(pPos.getX() - 10, pPos.getZ() - 10, pPos.getX() + 10, pPos.getZ() + 10) || !svlevel.isPositionEntityTicking((BlockPos)pPos) || !spawnplacementtype.isSpawnPositionOk((LevelReader)svlevel, (BlockPos)pPos, EntityType.RAVAGER) && (!svlevel.getBlockState(pPos.below()).is(Blocks.SNOW) || !svlevel.getBlockState((BlockPos)pPos).isAir())) continue;
            return pPos;
        }
        return null;
    }

    private static boolean canBeSeenOnSurface(ServerLevel svlevel, Player player) {
        BlockPos blockpos = BlockPos.containing((double)player.getX(), (double)player.getEyeY(), (double)player.getZ());
        float brightness = svlevel.getBrightness(LightLayer.SKY, blockpos);
        return svlevel.random.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && svlevel.canSeeSky(blockpos);
    }
}

