/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers.objectives;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.PlayerObjectives;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class ObjectiveDamageEvents {
    @SubscribeEvent
    public static void onPlayerDamagedObjective(LivingDamageEvent.Post event) {
        LivingEntity victim = event.getEntity();
        Level level = victim.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        if (!victim.getType().equals(EntityType.PLAYER)) {
            return;
        }
        PlayerObjective obj = ObjectiveUtil.getGoingObjective(svlevel);
        float damage = event.getNewDamage();
        if ((obj.is((Level)svlevel, PlayerObjectives.SUFFERING) || obj.is((Level)svlevel, PlayerObjectives.PAIN) || obj.is((Level)svlevel, PlayerObjectives.CRUEL_SUFFERING)) && victim.getType().equals(EntityType.PLAYER)) {
            ObjectiveUtil.addProgress(svlevel, (int)damage);
        }
    }
}

