/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.events.subscribers.objectives;

import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.PlayerObjectives;
import xyz.mrfrostydev.welcomeplayer.registries.EntityRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.TagRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

@EventBusSubscriber(modid="welcomeplayer")
public class ObjectiveKillEvents {
    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel svlevel = (ServerLevel)level;
        if (event.getSource().getEntity() == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!attacker.getType().equals(EntityType.PLAYER)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.METAL_ROSES, EntityType.IRON_GOLEM)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.DUCK_HUNT, EntityType.CHICKEN)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.THE_SHEPHERD, (LivingEntity e) -> e.getType().equals(EntityType.SHEEP) || e.getType().equals(EntityType.GOAT))) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.PEST_CONTROL, TagRegistry.BUG)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.ZOMBIE_KILLER, EntityType.ZOMBIE)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.THE_BUTCHER, TagRegistry.ANIMAL)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.SET_BATTLE, TagRegistry.HOST_ROBOT)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.MONSTER_HUNTER, TagRegistry.UNDEAD)) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.PURE_VIOLENCE, (LivingEntity e) -> !e.getType().equals(EntityType.PLAYER))) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.ENDLESS_VIOLENCE, (LivingEntity e) -> !e.getType().equals(EntityType.PLAYER))) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.GOLIATH, (EntityType)EntityRegistry.ERADICATOR.get())) {
            return;
        }
        if (ObjectiveKillEvents.compareEntityWithObjective(svlevel, entity, PlayerObjectives.NIGHT_KILLER, EntityType.WARDEN)) {
            return;
        }
    }

    public static boolean compareEntityWithObjective(ServerLevel svlevel, LivingEntity entity, ResourceKey<PlayerObjective> event, Predicate<LivingEntity> predicate) {
        boolean isTrue;
        boolean bl = isTrue = ObjectiveUtil.isCurrentObjective(svlevel, event) && predicate.test(entity);
        if (isTrue) {
            ObjectiveUtil.addProgress(svlevel, 1);
        }
        return isTrue;
    }

    public static boolean compareEntityWithObjective(ServerLevel svlevel, LivingEntity entity, ResourceKey<PlayerObjective> event, EntityType<?> entityType) {
        boolean isTrue;
        boolean bl = isTrue = ObjectiveUtil.isCurrentObjective(svlevel, event) && entity.getType().equals(entityType);
        if (isTrue) {
            ObjectiveUtil.addProgress(svlevel, 1);
        }
        return isTrue;
    }

    public static boolean compareEntityWithObjective(ServerLevel svlevel, LivingEntity entity, ResourceKey<PlayerObjective> event, TagKey<EntityType<?>> tag) {
        boolean isTrue;
        boolean bl = isTrue = ObjectiveUtil.isCurrentObjective(svlevel, event) && entity.getType().is(tag);
        if (isTrue) {
            ObjectiveUtil.addProgress(svlevel, 1);
        }
        return isTrue;
    }
}

