/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.items.gadgets;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.client.renderers.item.LaserCutterItemRenderer;
import xyz.mrfrostydev.welcomeplayer.registries.DataComponentRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

public class LaserCutterItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation DEPLOY_ANIM = RawAnimation.begin().thenPlay("laser_cutter.animation.deploy");
    private static final RawAnimation RETRACT_ANIM = RawAnimation.begin().thenPlay("laser_cutter.animation.retract");

    public LaserCutterItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level instanceof ServerLevel) {
            int tickCount = level.getServer().getTickCount();
            if (((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGING, (Object)false)).booleanValue() && tickCount % 60 == 0) {
                stack.setDamageValue(stack.getDamageValue() - 1);
                if (stack.getDamageValue() <= 0) {
                    stack.set(DataComponentRegistry.CHARGING, (Object)false);
                }
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        int damage = (Integer)stack.getOrDefault(DataComponents.DAMAGE, (Object)0);
        if (damage < stack.getMaxDamage() && !((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGING, (Object)false)).booleanValue()) {
            if (!player.hasInfiniteMaterials()) {
                stack.setDamageValue(stack.getDamageValue() + 1);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEventRegistry.LASER_CUTTER_SWING, player.getSoundSource(), 1.0f, player.level().getRandom().nextFloat() * 0.4f + 0.8f);
            return false;
        }
        stack.set(DataComponentRegistry.CHARGING, (Object)true);
        return true;
    }

    public static boolean isCharging(ItemStack stack) {
        return (Boolean)stack.getOrDefault(DataComponentRegistry.CHARGING, (Object)false);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private LaserCutterItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new LaserCutterItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimation));
    }

    private <T extends GeoItem> PlayState handleAnimation(AnimationState<T> state) {
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        if (stack == null) {
            return PlayState.STOP;
        }
        if (((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGING, (Object)false)).booleanValue()) {
            return state.setAndContinue(RETRACT_ANIM);
        }
        return state.setAndContinue(DEPLOY_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

