/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.items.gadgets;

import java.util.ArrayDeque;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.client.renderers.item.PhaseLinkItemRenderer;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

public class PhaseLinkItem
extends Item
implements GeoItem {
    int maxBlinkDistance;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation USE_ANIM = RawAnimation.begin().thenPlay("phase_link.animation.use");
    private static final RawAnimation USE_OFFHAND_ANIM = RawAnimation.begin().thenPlay("phase_link.animation.use_offhand");

    public PhaseLinkItem(Item.Properties properties, int blinkDistance) {
        super(properties);
        this.maxBlinkDistance = blinkDistance;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack usedStack = player.getItemInHand(usedHand);
        BlockPos curPos = player.blockPosition();
        Direction dir = player.getDirection();
        BlockPos newPos = curPos.relative(dir);
        if (usedHand == InteractionHand.MAIN_HAND) {
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)usedStack), "Use", "use");
        } else {
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)usedStack), "Use", "use_offhand");
        }
        ArrayDeque<BlockPos> freeSpaces = new ArrayDeque<BlockPos>();
        for (int i = 0; i < this.maxBlinkDistance; ++i) {
            if (PhaseLinkItem.safeToBlink(level, newPos)) {
                freeSpaces.push(newPos);
            }
            newPos = newPos.relative(dir);
        }
        if (!freeSpaces.isEmpty() && PhaseLinkItem.safeToBlink(level, (BlockPos)freeSpaces.peek())) {
            newPos = (BlockPos)freeSpaces.pop();
            player.teleportTo((double)newPos.getX() + 0.5, (double)newPos.getY(), (double)newPos.getZ() + 0.5);
            player.getCooldowns().addCooldown((Item)this, 100);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEventRegistry.PHASE_BLINK, player.getSoundSource(), 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            return InteractionResultHolder.consume((Object)usedStack);
        }
        player.getCooldowns().addCooldown((Item)this, 10);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEventRegistry.PHASE_BLINK_BEEP, player.getSoundSource(), 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
        return InteractionResultHolder.fail((Object)usedStack);
    }

    private static boolean safeToBlink(Level level, BlockPos checkPos) {
        return level.getBlockState(checkPos).isAir() && level.getBlockState(checkPos.above()).isAir();
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private PhaseLinkItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PhaseLinkItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Use", 0, this::handleAnim).triggerableAnim("use", USE_ANIM).triggerableAnim("use_offhand", USE_OFFHAND_ANIM).receiveTriggeredAnimations());
    }

    public PlayState handleAnim(AnimationState<PhaseLinkItem> state) {
        if (((ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE)).firstPerson()) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

