/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.items.gadgets;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.client.renderers.item.SeismicLauncherItemRenderer;
import xyz.mrfrostydev.welcomeplayer.entities.projectiles.SeismicBlastProjectile;
import xyz.mrfrostydev.welcomeplayer.registries.DataComponentRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ItemRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

@EventBusSubscriber
public class SeismicLauncherItem
extends Item
implements GeoItem {
    private static final int COOLDOWN = 100;
    private static final int CHARGE_TIME = 25;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CHARGE_ANIM = RawAnimation.begin().thenPlay("seismic_launcher.animation.charge");
    private static final RawAnimation CHARGE_HOLD_ANIM = RawAnimation.begin().thenPlay("seismic_launcher.animation.charge_hold");
    private static final RawAnimation FIRE_ANIM = RawAnimation.begin().thenPlay("seismic_launcher.animation.fire");
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("seismic_launcher.animation.idle");

    public SeismicLauncherItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isUsingItem()) {
            player.startUsingItem(hand);
            stack.set(DataComponentRegistry.CHARGING, (Object)true);
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "General", "charge");
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        stack.set(DataComponentRegistry.CHARGING, (Object)false);
        if (timeCharged <= 0) {
            Vec3 lookPos = livingEntity.getEyePosition();
            Vec3 lookVec = livingEntity.getLookAngle().normalize().scale(1.3);
            Vec3 shootPos = lookPos.add(lookVec);
            SeismicBlastProjectile blast = new SeismicBlastProjectile(level, (Entity)livingEntity, shootPos.x, shootPos.y, shootPos.z);
            blast.shoot(lookVec.x, lookVec.y, lookVec.z, 0.5f, 0.0f);
            level.addFreshEntity((Entity)blast);
            livingEntity.setDeltaMovement(lookVec.normalize().scale(-1.2));
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCooldowns().addCooldown((Item)this, 100);
                this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "General", "fire");
            }
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.SEISMIC_SLAM, livingEntity.getSoundSource(), 2.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration == 24) {
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.SEISMIC_CHARGE, livingEntity.getSoundSource(), 0.8f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onUsingWhileCharging(LivingEntityUseItemEvent.Tick event) {
        ServerLevel svlevel;
        LivingEntity livingEntity;
        Level level;
        if (event.getItem().is(ItemRegistry.SEISMIC_LAUNCHER) && event.getDuration() < 5 && (level = (livingEntity = event.getEntity()).level()) instanceof ServerLevel && (svlevel = (ServerLevel)level).getServer().getTickCount() % 12 == 0) {
            svlevel.playSound(null, livingEntity.getX(), livingEntity.getEyeY(), livingEntity.getZ(), SoundEventRegistry.SEISMIC_CHARGE_HOLD, livingEntity.getSoundSource(), 0.6f, 1.0f);
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        stack.set(DataComponentRegistry.CHARGING, (Object)false);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 25;
    }

    public boolean useOnRelease(ItemStack stack) {
        return true;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SeismicLauncherItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SeismicLauncherItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "General", this::handleAnimation).triggerableAnim("fire", FIRE_ANIM).triggerableAnim("charge", CHARGE_ANIM).receiveTriggeredAnimations());
    }

    private <T extends GeoItem> PlayState handleAnimation(AnimationState<T> state) {
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        if (stack == null) {
            return PlayState.STOP;
        }
        if (((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGING, (Object)false)).booleanValue()) {
            if (state.isCurrentAnimation(CHARGE_ANIM) && state.getController().hasAnimationFinished()) {
                return state.setAndContinue(CHARGE_HOLD_ANIM);
            }
        } else if (!state.isCurrentAnimation(FIRE_ANIM) || state.getController().hasAnimationFinished()) {
            return state.setAndContinue(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

