/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.items.gadgets;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.client.renderers.item.ShockOrbLauncherItemRenderer;
import xyz.mrfrostydev.welcomeplayer.entities.projectiles.ShockChargeProjectile;
import xyz.mrfrostydev.welcomeplayer.registries.DataComponentRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ItemRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ParticleRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

@EventBusSubscriber
public class ShockOrbLauncherItem
extends Item
implements GeoItem {
    private static final int COOLDOWN = 30;
    private static final int CHARGE_TIME = 60;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CHARGE_ANIM = RawAnimation.begin().thenPlay("shock_orb_launcher.animation.charge");
    private static final RawAnimation CHARGE_HOLD_ANIM = RawAnimation.begin().thenPlay("shock_orb_launcher.animation.charge_hold");
    private static final RawAnimation FIRE_ANIM = RawAnimation.begin().thenPlay("shock_orb_launcher.animation.fire");
    private static final RawAnimation STABLE_ANIM = RawAnimation.begin().thenPlay("shock_orb_launcher.animation.stable");
    private static final RawAnimation UNSTABLE_ANIM = RawAnimation.begin().thenPlay("shock_orb_launcher.animation.unstable");
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("shock_orb_launcher.animation.idle");

    public ShockOrbLauncherItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            if (((Boolean)stack.getOrDefault(DataComponentRegistry.UNSTABLE, (Object)false)).booleanValue()) {
                stack.set(DataComponentRegistry.UNSTABLE, (Object)false);
            } else {
                stack.set(DataComponentRegistry.UNSTABLE, (Object)true);
            }
            player.getCooldowns().addCooldown((Item)this, 10);
        } else if (!player.isUsingItem()) {
            player.startUsingItem(hand);
            stack.set(DataComponentRegistry.CHARGING, (Object)true);
            this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "General", "charge");
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        stack.set(DataComponentRegistry.CHARGING, (Object)false);
        if (timeCharged <= 0) {
            boolean unstable = (Boolean)stack.getOrDefault(DataComponentRegistry.UNSTABLE, (Object)false);
            Vec3 lookPos = livingEntity.getEyePosition();
            Vec3 lookVec = livingEntity.getLookAngle().normalize().scale(1.3);
            Vec3 shootPos = lookPos.add(lookVec);
            ShockChargeProjectile charge = new ShockChargeProjectile(level, (Entity)livingEntity, shootPos.x, shootPos.y, shootPos.z, unstable);
            charge.shoot(lookVec.x, lookVec.y, lookVec.z, 0.2f, 0.0f);
            level.addFreshEntity((Entity)charge);
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.getCooldowns().addCooldown((Item)this, 30);
                this.triggerAnim((Entity)player, GeoItem.getId((ItemStack)stack), "General", "fire");
            }
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.LAUNCHER_BLAST, livingEntity.getSoundSource(), 1.5f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration == 59) {
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEventRegistry.LAUNCHER_CHARGE, livingEntity.getSoundSource(), 0.8f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
        if (remainingUseDuration % 10 == 0) {
            Vec3 vec3 = livingEntity.getUpVector(1.0f);
            float angle = livingEntity.getXRot();
            Vec3 vec31 = livingEntity.getViewVector(1.0f);
            Quaternionf quaternionfoffset = new Quaternionf().setAngleAxis((double)((angle - 11.0f) * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vector3f vector3foffset = vec31.toVector3f().rotate((Quaternionfc)quaternionfoffset);
            level.addParticle((ParticleOptions)ParticleRegistry.SHOCK_CHARGE.get(), livingEntity.getX() + (double)vector3foffset.x, livingEntity.getEyeY() - (double)0.3f + (double)vector3foffset.y, livingEntity.getZ() + (double)vector3foffset.z, 1.0, 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public static void onUsingWhileCharging(LivingEntityUseItemEvent.Tick event) {
        ServerLevel svlevel;
        LivingEntity livingEntity;
        Level level;
        if (event.getItem().is(ItemRegistry.SHOCK_ORB_LAUNCHER) && event.getDuration() < 8 && (level = (livingEntity = event.getEntity()).level()) instanceof ServerLevel && (svlevel = (ServerLevel)level).getServer().getTickCount() % 16 == 0) {
            svlevel.playSound(null, livingEntity.getX(), livingEntity.getEyeY(), livingEntity.getZ(), SoundEventRegistry.SHOCK_HUM, livingEntity.getSoundSource(), 0.6f, 1.2f);
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        stack.set(DataComponentRegistry.CHARGING, (Object)false);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 60;
    }

    public boolean useOnRelease(ItemStack stack) {
        return true;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private ShockOrbLauncherItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ShockOrbLauncherItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "General", this::handleAnimation).triggerableAnim("fire", FIRE_ANIM).triggerableAnim("charge", CHARGE_ANIM).receiveTriggeredAnimations());
        controllers.add(new AnimationController((GeoAnimatable)this, "Stable", this::handleStableAnimation));
    }

    private <T extends GeoItem> PlayState handleAnimation(AnimationState<T> state) {
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        if (stack == null) {
            return PlayState.STOP;
        }
        if (((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGING, (Object)false)).booleanValue()) {
            if (state.isCurrentAnimation(CHARGE_ANIM) && state.getController().hasAnimationFinished()) {
                return state.setAndContinue(CHARGE_HOLD_ANIM);
            }
        } else if (!state.isCurrentAnimation(FIRE_ANIM) || state.getController().hasAnimationFinished()) {
            return state.setAndContinue(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoItem> PlayState handleStableAnimation(AnimationState<T> state) {
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        if (stack == null) {
            return PlayState.STOP;
        }
        if (((Boolean)stack.getOrDefault(DataComponentRegistry.UNSTABLE, (Object)false)).booleanValue()) {
            state.resetCurrentAnimation();
            return state.setAndContinue(UNSTABLE_ANIM);
        }
        state.resetCurrentAnimation();
        return state.setAndContinue(STABLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

