/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.items.gadgets;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;
import xyz.mrfrostydev.welcomeplayer.client.renderers.item.StasisStickItemRenderer;
import xyz.mrfrostydev.welcomeplayer.registries.DataComponentRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.MobEffectRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.SoundEventRegistry;

public class StasisStickItem
extends Item
implements GeoItem {
    private static final int COOLDOWN = 200;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation ACTIVE_ANIM = RawAnimation.begin().thenPlay("stasis_stick.animation.active");
    private static final RawAnimation DEACTIVE_ANIM = RawAnimation.begin().thenPlay("stasis_stick.animation.deactive");

    public StasisStickItem(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static ItemAttributeModifiers createAttributes(float attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGED, (Object)false)).booleanValue()) {
                if (!player.getCooldowns().isOnCooldown((Item)this)) {
                    stack.set(DataComponentRegistry.CHARGED, (Object)true);
                }
            } else if (((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGED, (Object)false)).booleanValue() && player.getCooldowns().isOnCooldown((Item)this)) {
                stack.set(DataComponentRegistry.CHARGED, (Object)false);
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (!player.getCooldowns().isOnCooldown((Item)this)) {
                player.getCooldowns().addCooldown((Item)this, 200);
                target.addEffect(new MobEffectInstance(MobEffectRegistry.STASIS, 80, 0));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEventRegistry.STASIS_IMPACT, player.getSoundSource(), 1.0f, player.level().getRandom().nextFloat() * 0.4f + 0.8f);
            }
        }
        return false;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private StasisStickItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new StasisStickItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this::handleAnimation));
    }

    private <T extends GeoItem> PlayState handleAnimation(AnimationState<T> state) {
        ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
        if (stack == null) {
            return PlayState.STOP;
        }
        if (((Boolean)stack.getOrDefault(DataComponentRegistry.CHARGED, (Object)false)).booleanValue()) {
            return state.setAndContinue(ACTIVE_ANIM);
        }
        return state.setAndContinue(DEACTIVE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

