/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.network;

import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.mrfrostydev.welcomeplayer.client.gui.menus.blocks.VendorMenu;
import xyz.mrfrostydev.welcomeplayer.data.VendorItem;

public record ServerVendorMenuPacket(List<VendorItem> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerVendorMenuPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"welcomeplayer", (String)"server_vendor_menu_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerVendorMenuPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)VendorItem.STREAM_CODEC.apply(ByteBufCodecs.list()), ServerVendorMenuPacket::data, ServerVendorMenuPacket::create);

    public static ServerVendorMenuPacket create(List<VendorItem> data) {
        return new ServerVendorMenuPacket(data);
    }

    public static void handle(ServerVendorMenuPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu containermenu = context.player().containerMenu;
            if (containermenu instanceof VendorMenu) {
                VendorMenu menu = (VendorMenu)containermenu;
                menu.setShopItems(packet.data);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)"ServerVendorMenuPacket could not send data: "));
            return null;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

