/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.utils;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class AnimatedSprite {
    protected ResourceLocation resource;
    protected int tickDelay;
    protected final int textureWidth;
    protected final int textureHeight;
    protected final int totalFrames;
    protected boolean isVisible;
    protected boolean isPlaying;
    protected boolean isLooping;
    protected int frame;
    protected int lastTick;
    protected int posX;
    protected int posY;
    protected final int imageHeight;

    public AnimatedSprite(ResourceLocation resource, int tickDelay, int textureWidth, int textureHeight, int totalFrames) {
        this.resource = resource;
        this.tickDelay = tickDelay;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.totalFrames = totalFrames;
        this.isPlaying = false;
        this.isLooping = false;
        this.frame = 0;
        this.lastTick = -1;
        this.posX = 0;
        this.posY = 0;
        this.imageHeight = textureHeight / totalFrames;
        this.isVisible = true;
    }

    public AnimatedSprite(ResourceLocation resource, int tickDelay, int posX, int posY, int textureWidth, int textureHeight, int totalFrames) {
        this.resource = resource;
        this.tickDelay = tickDelay;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.totalFrames = totalFrames;
        this.isPlaying = false;
        this.isLooping = false;
        this.frame = 0;
        this.lastTick = -1;
        this.posX = posX;
        this.posY = posY;
        this.imageHeight = textureHeight / totalFrames;
        this.isVisible = true;
    }

    public void render(GuiGraphics guiGraphics, int tick, float partialTick) {
        if (!this.isVisible) {
            return;
        }
        guiGraphics.blitSprite(this.resource, this.textureWidth, this.textureHeight, 0, this.imageHeight * this.frame, this.posX, this.posY, this.textureWidth, this.imageHeight);
        if (this.isPlaying && this.lastTick != tick && tick % this.tickDelay == 0) {
            if (this.lastTick < 0) {
                this.lastTick = tick;
                return;
            }
            this.lastTick = tick;
            ++this.frame;
            if (this.frame >= this.totalFrames) {
                if (this.isLooping) {
                    this.frame = 0;
                } else {
                    this.frame = this.totalFrames - 1;
                    this.stop();
                }
            }
        }
    }

    public void play() {
        if (!this.isPlaying) {
            this.isPlaying = true;
            this.isLooping = false;
        }
    }

    public void playLoop() {
        if (!this.isPlaying) {
            this.isLooping = true;
            this.isPlaying = true;
        }
    }

    public void reset() {
        this.frame = 0;
        this.stop();
    }

    public void stop() {
        if (this.isPlaying) {
            this.isPlaying = false;
        }
    }

    public void setResource(ResourceLocation resource) {
        this.resource = resource;
    }

    public void setPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public void setFrame(int value) {
        this.frame = value >= this.totalFrames ? this.totalFrames - 1 : value;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean hasEnded() {
        if (this.isLooping) {
            return false;
        }
        return this.frame >= this.totalFrames - 1;
    }
}

