/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEventManager;
import xyz.mrfrostydev.welcomeplayer.data.AudienceMood;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;
import xyz.mrfrostydev.welcomeplayer.events.AudienceEventEndEvent;
import xyz.mrfrostydev.welcomeplayer.events.AudienceEventStartedEvent;
import xyz.mrfrostydev.welcomeplayer.network.ServerShowHostMessagePacket;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;

public class AudienceEventUtil {
    private static final Random RANDOM = new Random();

    public static void pickEvent(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        AudienceEventManager manager = data.getEventManager();
        AudienceMood mood = data.getMood();
        AudiencePhase phase = data.getPhase();
        AudienceEvent previousEvent = manager.getGoingEvent();
        NeoForge.EVENT_BUS.post((Event)new AudienceEventEndEvent((Level)svlevel, data, previousEvent));
        List allEvents = manager.getEventMap().getOrDefault(phase, new ArrayList());
        ArrayList<AudienceEvent> events = new ArrayList<AudienceEvent>();
        for (AudienceEvent e : allEvents) {
            if (!mood.equals(e.mood())) continue;
            events.add(e);
        }
        AudienceEvent event = AudienceEvent.NOTHING;
        if (!events.isEmpty()) {
            int rnd = RANDOM.nextInt(events.size());
            event = (AudienceEvent)events.get(rnd);
            while (event.is(previousEvent) && events.size() > 1) {
                rnd = RANDOM.nextInt(events.size());
                event = (AudienceEvent)events.get(rnd);
            }
        }
        AudienceEventUtil.sendEventDialog(event);
        manager.setGoingEvent(event);
        data.setDirty();
        NeoForge.EVENT_BUS.post((Event)new AudienceEventStartedEvent((Level)svlevel, data, event));
        AudienceUtil.syncToClients(svlevel);
    }

    public static void setGoingEvent(ServerLevel svlevel, AudienceEvent event) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        AudienceEventManager manager = data.getEventManager();
        NeoForge.EVENT_BUS.post((Event)new AudienceEventEndEvent((Level)svlevel, data, manager.getGoingEvent()));
        AudienceEventUtil.sendEventDialog(event);
        manager.setGoingEvent(event);
        data.setDirty();
        NeoForge.EVENT_BUS.post((Event)new AudienceEventStartedEvent((Level)svlevel, data, event));
        AudienceUtil.syncToClients(svlevel);
    }

    public static AudienceEvent getGoingEvent(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        AudienceEventManager manager = data.getEventManager();
        return manager.getGoingEvent();
    }

    public static void sendEventDialog(AudienceEvent event) {
        if (event.is(AudienceEvent.NOTHING)) {
            return;
        }
        List<Component> eventDialog = event.dialog();
        for (Component comp : eventDialog) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)ServerShowHostMessagePacket.create(comp), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

