/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.AudienceEvent;
import xyz.mrfrostydev.welcomeplayer.data.AudienceMood;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;
import xyz.mrfrostydev.welcomeplayer.network.ServerShowHostMessagePacket;
import xyz.mrfrostydev.welcomeplayer.network.SyncAudienceDataLargePacket;
import xyz.mrfrostydev.welcomeplayer.network.SyncAudienceDataSmallPacket;
import xyz.mrfrostydev.welcomeplayer.registries.DatapackRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceEventUtil;
import xyz.mrfrostydev.welcomeplayer.utils.ObjectiveUtil;

public class AudienceUtil {
    private static Random RANDOM = new Random();

    public static AudienceData computeAudienceData(ServerLevel svlevel) {
        SavedData savedData = svlevel.getServer().overworld().getDataStorage().computeIfAbsent(AudienceData.factory(), "audience_data");
        if (savedData instanceof AudienceData) {
            AudienceData AudienceData2 = (AudienceData)savedData;
            AudienceUtil.initializeAudienceEvents(AudienceData2, svlevel);
            return AudienceData2;
        }
        throw new ClassCastException("Saved data computed was not an instance of AudienceData");
    }

    public static void initializeAudienceEvents(AudienceData data, ServerLevel svlevel) {
        List events = svlevel.registryAccess().registryOrThrow(DatapackRegistry.AUDIENCE_EVENTS).stream().toList();
        ArrayList<AudienceEvent> adoredEvents = new ArrayList<AudienceEvent>();
        ArrayList<AudienceEvent> likedEvents = new ArrayList<AudienceEvent>();
        ArrayList<AudienceEvent> neutralEvents = new ArrayList<AudienceEvent>();
        ArrayList<AudienceEvent> dislikedEvents = new ArrayList<AudienceEvent>();
        ArrayList<AudienceEvent> hatedEvents = new ArrayList<AudienceEvent>();
        for (AudienceEvent e : events) {
            if (e.phase().equals(AudiencePhase.THRILLED)) {
                adoredEvents.add(e);
                continue;
            }
            if (e.phase().equals(AudiencePhase.INTERESTED)) {
                likedEvents.add(e);
                continue;
            }
            if (e.phase().equals(AudiencePhase.BORED)) {
                dislikedEvents.add(e);
                continue;
            }
            if (e.phase().equals(AudiencePhase.FURIOUS)) {
                hatedEvents.add(e);
                continue;
            }
            neutralEvents.add(e);
        }
        HashMap<AudiencePhase, List<AudienceEvent>> eventMap = new HashMap<AudiencePhase, List<AudienceEvent>>();
        eventMap.put(AudiencePhase.THRILLED, adoredEvents);
        eventMap.put(AudiencePhase.INTERESTED, likedEvents);
        eventMap.put(AudiencePhase.NEUTRAL, neutralEvents);
        eventMap.put(AudiencePhase.BORED, dislikedEvents);
        eventMap.put(AudiencePhase.FURIOUS, hatedEvents);
        for (Map.Entry entry : eventMap.entrySet()) {
            if (!((List)entry.getValue()).isEmpty()) continue;
            eventMap.put((AudiencePhase)entry.getKey(), List.of(AudienceEvent.NOTHING));
        }
        data.getEventManager().setEventMap(eventMap);
        data.setDirty();
    }

    public static void startGameShow(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.setActive(true);
        ObjectiveUtil.pickObjective(svlevel);
        AudienceEventUtil.setGoingEvent(svlevel, AudienceEvent.NOTHING);
    }

    public static void stopGameShow(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.setActive(false);
    }

    public static AudienceData getAudienceData(ServerLevel svlevel) {
        SavedData savedData = svlevel.getServer().overworld().getDataStorage().get(AudienceData.factory(), "audience_data");
        if (savedData instanceof AudienceData) {
            AudienceData AudienceData2 = (AudienceData)savedData;
            return AudienceData2;
        }
        throw new ClassCastException("Saved data get was not an instance of AudienceData");
    }

    public static void startChangeCooldown(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.startChangeCooldown();
    }

    public static boolean isActive(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        return data.isActive();
    }

    public static boolean isChangeCooldown(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        return data.getChangeCooldown() > 0;
    }

    public static boolean isPhaseShifting(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        return data.isPhaseShifting();
    }

    public static void restartPhaseShift(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.restartPhaseShift();
    }

    public static void pickMood(ServerLevel svlevel) {
        AudiencePhase phase = AudienceUtil.getPhase(svlevel);
        ArrayList<AudienceMood> possibleMoods = new ArrayList<AudienceMood>();
        if (phase.equals(AudiencePhase.THRILLED)) {
            possibleMoods.add(AudienceMood.HAPPY);
            possibleMoods.add(AudienceMood.SAD);
            possibleMoods.add(AudienceMood.CRUEL);
        } else if (phase.equals(AudiencePhase.INTERESTED)) {
            possibleMoods.add(AudienceMood.NEUTRAL);
            possibleMoods.add(AudienceMood.HAPPY);
            possibleMoods.add(AudienceMood.SAD);
            possibleMoods.add(AudienceMood.ANGRY);
        } else if (phase.equals(AudiencePhase.BORED)) {
            possibleMoods.add(AudienceMood.NEUTRAL);
            possibleMoods.add(AudienceMood.SAD);
            possibleMoods.add(AudienceMood.ANGRY);
        } else if (phase.equals(AudiencePhase.FURIOUS)) {
            possibleMoods.add(AudienceMood.ANGRY);
            possibleMoods.add(AudienceMood.CRUEL);
        } else {
            possibleMoods.add(AudienceMood.NEUTRAL);
            possibleMoods.add(AudienceMood.HAPPY);
            possibleMoods.add(AudienceMood.SAD);
        }
        Collections.shuffle(possibleMoods);
        AudienceMood rndMood = (AudienceMood)possibleMoods.stream().findAny().orElseThrow();
        AudienceUtil.setMood(svlevel, rndMood);
    }

    public static int getInterest(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        return data.getInterest();
    }

    public static void setInterest(ServerLevel svlevel, int set) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.setInterest(AudienceUtil.modifyWithMood(svlevel, set));
    }

    public static void setInterestRaw(ServerLevel svlevel, int set) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.setInterest(set);
    }

    public static void addInterest(ServerLevel svlevel, int add) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        int addModified = add;
        addModified = AudienceUtil.modifyWithThreshold(svlevel, addModified);
        addModified = AudienceUtil.modifyWithMood(svlevel, addModified);
        data.addInterest(addModified);
    }

    public static void addInterestRaw(ServerLevel svlevel, int add) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.addInterest(add);
    }

    public static AudiencePhase getPhase(ServerLevel svlevel) {
        int favour = AudienceUtil.getInterest(svlevel);
        if (favour > 1000) {
            return AudiencePhase.THRILLED;
        }
        if (favour > 400) {
            return AudiencePhase.INTERESTED;
        }
        if (favour > -400) {
            return AudiencePhase.NEUTRAL;
        }
        if (favour > -1000) {
            return AudiencePhase.BORED;
        }
        return AudiencePhase.FURIOUS;
    }

    public static void setMood(ServerLevel svlevel, AudienceMood set) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.setMood(set);
        AudienceUtil.syncToClients(svlevel);
    }

    public static AudienceMood getMood(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        return data.getMood();
    }

    public static void doTick(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        data.tickChangeCooldown();
        data.tickCheckPhaseShift();
    }

    public static void sendDialog(Component component) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)ServerShowHostMessagePacket.create(component), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendDialog(Component component, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)ServerShowHostMessagePacket.create(component), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void syncToClients(ServerLevel svlevel) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)SyncAudienceDataSmallPacket.create(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)SyncAudienceDataLargePacket.create(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static int modifyWithThreshold(ServerLevel svlevel, int add) {
        boolean isNeg = add < 0;
        AudiencePhase phase = AudienceUtil.getPhase(svlevel);
        if (phase == AudiencePhase.THRILLED) {
            return isNeg ? Mth.floor((float)((float)add * 1.75f)) : Mth.floor((float)((float)add * 0.25f));
        }
        if (phase == AudiencePhase.INTERESTED) {
            return isNeg ? Mth.floor((float)((float)add * 1.5f)) : Mth.floor((float)((float)add * 0.5f));
        }
        if (phase == AudiencePhase.BORED) {
            return Mth.floor((float)((float)add * 1.5f));
        }
        if (phase == AudiencePhase.FURIOUS) {
            return Mth.floor((float)((float)add * 1.75f));
        }
        return Mth.floor((float)((float)add * 1.0f));
    }

    private static int modifyWithMood(ServerLevel svlevel, int value) {
        AudienceData data = AudienceUtil.getAudienceData(svlevel);
        boolean isNeg = value < 0;
        float modifier = 1.0f;
        AudienceMood mood = data.getMood();
        if (mood == AudienceMood.HAPPY) {
            float f = modifier = isNeg ? 0.5f : 1.5f;
        }
        if (mood == AudienceMood.SAD) {
            float f = modifier = isNeg ? 1.25f : 0.75f;
        }
        if (mood == AudienceMood.ANGRY) {
            float f = modifier = isNeg ? 1.5f : 0.5f;
        }
        if (mood == AudienceMood.CRUEL) {
            modifier = isNeg ? 1.75f : 0.25f;
        }
        return Mth.ceil((float)((float)value * modifier));
    }
}

