/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.utils;

import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.mrfrostydev.welcomeplayer.data.AudienceData;
import xyz.mrfrostydev.welcomeplayer.data.AudiencePhase;
import xyz.mrfrostydev.welcomeplayer.data.AudienceReward;
import xyz.mrfrostydev.welcomeplayer.data.ClientObjectiveData;
import xyz.mrfrostydev.welcomeplayer.data.ObjectiveManagerData;
import xyz.mrfrostydev.welcomeplayer.data.PlayerObjective;
import xyz.mrfrostydev.welcomeplayer.data.datagen.providers.datapacks.PlayerObjectives;
import xyz.mrfrostydev.welcomeplayer.events.ObjectiveEndEvent;
import xyz.mrfrostydev.welcomeplayer.events.ObjectiveStartedEvent;
import xyz.mrfrostydev.welcomeplayer.network.ServerShowHostMessagePacket;
import xyz.mrfrostydev.welcomeplayer.network.SyncObjectiveDataPacket;
import xyz.mrfrostydev.welcomeplayer.registries.DatapackRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ItemRegistry;
import xyz.mrfrostydev.welcomeplayer.registries.ParticleRegistry;
import xyz.mrfrostydev.welcomeplayer.utils.AudienceUtil;

public class ObjectiveUtil {
    public static Random RANDOM = new Random();
    public static int OBJECTIVE_TIME_LIMIT = 72000;

    public static ObjectiveManagerData computeObjectiveManagerData(ServerLevel svlevel) {
        SavedData savedData = svlevel.getServer().overworld().getDataStorage().computeIfAbsent(ObjectiveManagerData.factory(), "objective_manager_data");
        if (savedData instanceof ObjectiveManagerData) {
            ObjectiveManagerData data = (ObjectiveManagerData)savedData;
            return data;
        }
        throw new ClassCastException("Saved data computed was not an instance of ObjectiveManagerData");
    }

    public static ObjectiveManagerData getObjectiveManager(ServerLevel svlevel) {
        SavedData savedData = svlevel.getServer().overworld().getDataStorage().get(ObjectiveManagerData.factory(), "objective_manager_data");
        if (savedData instanceof ObjectiveManagerData) {
            ObjectiveManagerData data = (ObjectiveManagerData)savedData;
            return data;
        }
        throw new ClassCastException("Saved data get was not an instance of ObjectiveManagerData");
    }

    public static void pickObjective(ServerLevel svlevel) {
        AudiencePhase phase = AudienceUtil.getPhase(svlevel);
        PlayerObjective previousObj = ObjectiveUtil.getGoingObjective(svlevel);
        List<PlayerObjective> objList = svlevel.registryAccess().registryOrThrow(DatapackRegistry.PLAYER_OBJECTIVES).stream().filter(o -> o.phase().is(phase)).toList();
        if (objList.size() <= 0) {
            throw new RuntimeException("While picking an objective, no options were available. Datapack may not have enough enabled objectives for this phase.");
        }
        int rand = RANDOM.nextInt(objList.size());
        PlayerObjective obj = objList.get(rand);
        while (obj.is(previousObj) && objList.size() > 1) {
            obj = objList.get(RANDOM.nextInt(objList.size()));
        }
        ObjectiveUtil.setGoingObjective(svlevel, obj);
    }

    public static void setGoingObjective(ServerLevel svlevel, PlayerObjective obj) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        AudienceData audData = AudienceUtil.getAudienceData(svlevel);
        data.setProgress(0);
        data.setTime(OBJECTIVE_TIME_LIMIT);
        NeoForge.EVENT_BUS.post((Event)new ObjectiveEndEvent((Level)svlevel, audData, data.getGoingObjective()));
        int pc = svlevel.getPlayers(s -> !s.isSpectator()).size();
        data.setMaxProgress(obj.playerScaling() ? (int)((double)obj.maxValue() + (double)(pc - 1) * ((double)obj.maxValue() * 0.5)) : obj.maxValue());
        ObjectiveUtil.sendEventDialog(obj);
        data.setGoingObjective(obj);
        data.setDirty();
        NeoForge.EVENT_BUS.post((Event)new ObjectiveStartedEvent((Level)svlevel, audData, obj));
        ObjectiveUtil.syncToClients(svlevel);
    }

    public static void failObjective(ServerLevel svlevel) {
        AudienceUtil.addInterestRaw(svlevel, -50);
        AudienceUtil.sendDialog((Component)Component.translatable((String)("dialog.welcomeplayer.objective.fail." + RANDOM.nextInt(5))));
        ObjectiveUtil.pickObjective(svlevel);
    }

    public static void completeObjective(ServerLevel svlevel) {
        AudiencePhase phase = AudienceUtil.getPhase(svlevel);
        AudienceUtil.addInterestRaw(svlevel, 100);
        AudienceUtil.sendDialog((Component)Component.translatable((String)("dialog.welcomeplayer.objective.success." + RANDOM.nextInt(5))));
        List<AudienceReward> rewardList = svlevel.registryAccess().registryOrThrow(DatapackRegistry.AUDIENCE_REWARDS).stream().filter(r -> r.phase().is(phase)).toList();
        if (rewardList.size() <= 0) {
            throw new RuntimeException("While picking a reward, no options were available. Datapack may not have enough enabled rewards for this phase.");
        }
        int rand = RANDOM.nextInt(rewardList.size());
        List players = svlevel.getPlayers(p -> !p.isSpectator());
        for (ServerPlayer player : players) {
            Vec3 playerPos = player.getPosition(1.0f).add(0.0, 1.0, 0.0);
            Vec3 playerDir = Vec3.directionFromRotation((Vec2)player.getRotationVector()).scale(2.0);
            Vec3 placementPos = playerPos.add(playerDir);
            ItemEntity itemEntity = new ItemEntity((Level)svlevel, placementPos.x, placementPos.y, placementPos.z, rewardList.get(rand).stack().copy(), 0.0, 0.0, 0.0);
            svlevel.addFreshEntity((Entity)itemEntity);
            svlevel.sendParticles((ParticleOptions)((SimpleParticleType)ParticleRegistry.WARP_REWARD.get()), placementPos.x, placementPos.y + 0.3, placementPos.z, 1, 0.0, 0.0, 0.0, 0.0);
            rand = RANDOM.nextInt(rewardList.size());
        }
        ObjectiveUtil.pickObjective(svlevel);
    }

    public static PlayerObjective getGoingObjective(Level level) {
        if (level instanceof ServerLevel) {
            ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager((ServerLevel)level);
            return data.getGoingObjective();
        }
        return ClientObjectiveData.get().getGoingObjective();
    }

    public static PlayerObjective getGoingObjective(ServerLevel svlevel) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        return data.getGoingObjective();
    }

    public static boolean isCurrentObjective(ServerLevel svlevel, ResourceKey<PlayerObjective> event) {
        return ObjectiveUtil.getGoingObjective(svlevel).is((Level)svlevel, event);
    }

    public static void doTick(ServerLevel svlevel) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        data.doTick(svlevel);
        ObjectiveUtil.syncToClients(svlevel);
    }

    public static int getProgress(ServerLevel svlevel) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        return data.getProgress();
    }

    public static void addProgress(ServerLevel svlevel, int add) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        data.addProgress(add);
        if (data.getProgress() >= data.getMaxProgress()) {
            ObjectiveUtil.completeObjective(svlevel);
        }
        ObjectiveUtil.syncToClients(svlevel);
    }

    public static void setProgress(ServerLevel svlevel, int value) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        data.setProgress(value);
        ObjectiveUtil.syncToClients(svlevel);
    }

    public static void syncToClients(ServerLevel svlevel) {
        ObjectiveManagerData data = ObjectiveUtil.getObjectiveManager(svlevel);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)SyncObjectiveDataPacket.create(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendEventDialog(PlayerObjective obj) {
        List<Component> eventDialog = obj.dialog();
        for (Component comp : eventDialog) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)ServerShowHostMessagePacket.create(comp), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static List<Holder.Reference<PlayerObjective>> getAllObjectivesAsReference(ServerLevel svlevel) {
        return svlevel.registryAccess().registryOrThrow(DatapackRegistry.PLAYER_OBJECTIVES).holders().toList();
    }

    public static boolean compareStackWithObjective(Level level, PlayerObjective curObj, ItemStack stack) {
        if (curObj.is(level, PlayerObjectives.FORCED_RESUPPLY) && stack.is(ItemRegistry.RAW_RETROSTEEL)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.DAY_LABOUR) && stack.is(ItemRegistry.RAW_RETROSTEEL)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.COAL_MINER) && (stack.is(Items.COAL) || stack.is(Items.CHARCOAL))) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.COPPER_AGE) && stack.is(Items.COPPER_INGOT)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.FARMER) && stack.is(Items.WHEAT)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.SHORT_FUSE) && stack.is(ItemRegistry.BATTERY)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.HUMAN_CHARGER) && stack.is(ItemRegistry.BATTERY)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.WONDER_EGGS) && stack.is(Items.GOLDEN_APPLE)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.RICH_DISPLAY) && stack.is(Items.DIAMOND)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.GOLD_RUSH) && stack.is(Items.GOLD_INGOT)) {
            return true;
        }
        if (curObj.is(level, PlayerObjectives.RATIONING) && stack.getComponents().has(DataComponents.FOOD)) {
            return true;
        }
        return curObj.is(level, PlayerObjectives.CARNIFEROUS_CROWD) && stack.getComponents().has(DataComponents.FOOD);
    }
}

