/*
 * Decompiled with CFR 0.152.
 */
package xyz.mrfrostydev.welcomeplayer.utils;

import java.util.ArrayDeque;
import xyz.mrfrostydev.welcomeplayer.utils.StringRevealer;

public class TextReader {
    private static final int TIME_BUFFER = 300;
    private int tickPerChar;
    private ArrayDeque<String> dialogDeque = new ArrayDeque();
    private StringRevealer stringReveal = new StringRevealer();
    private String currentText = "";
    private String displayText = "";
    private int messageTime = 0;
    private boolean permanent;

    public TextReader(int tickPerChar) {
        this.tickPerChar = tickPerChar;
        this.permanent = false;
    }

    public void tick() {
        if (!this.dialogDeque.isEmpty() && this.currentText.isEmpty()) {
            this.currentText = this.dialogDeque.pop();
            int len = this.currentText.length();
            this.stringReveal.setString(this.currentText);
            this.messageTime = len * this.tickPerChar + 300;
        }
        if (this.messageTime <= 0) {
            this.currentText = "";
            if (!this.permanent) {
                this.displayText = "";
            }
        }
        if (this.messageTime > 0) {
            --this.messageTime;
            if (this.messageTime % this.tickPerChar == 0) {
                this.displayText = this.stringReveal.reveal();
            }
        }
    }

    public void addText(String message) {
        this.dialogDeque.add(message);
        this.permanent = false;
    }

    public void addText(String message, int tickPerChar) {
        this.tickPerChar = tickPerChar;
        this.dialogDeque.add(message);
        this.permanent = false;
    }

    public void addPermenantText(String message) {
        this.dialogDeque.add(message);
        this.permanent = true;
    }

    public void addPermenantText(String message, int tickPerChar) {
        this.tickPerChar = tickPerChar;
        this.dialogDeque.add(message);
        this.permanent = true;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public ArrayDeque<String> getDialogQueue() {
        return this.dialogDeque;
    }

    public int getMessageTime() {
        return this.messageTime;
    }

    public boolean isTextFullyDisplayed() {
        return this.stringReveal.isRevealed();
    }
}

