/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.petemc.mutantszombies.client.state.SpitterEntityRenderState;
import org.jetbrains.annotations.NotNull;

public class SpitterModel
extends EntityModel<SpitterEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Identifier.fromNamespaceAndPath((String)"mutantszombies", (String)"spitter_layer"), "main");
    public final ModelPart head2;
    public final ModelPart head3;
    public final ModelPart head4;
    public final ModelPart head5;
    public final ModelPart head6;
    public final ModelPart head7;
    public final ModelPart head8;
    public final ModelPart torso;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public SpitterModel(ModelPart root) {
        super(root);
        this.head2 = root.getChild("head2");
        this.head3 = root.getChild("head3");
        this.head4 = root.getChild("head4");
        this.head5 = root.getChild("head5");
        this.head6 = root.getChild("head6");
        this.head7 = root.getChild("head7");
        this.head8 = root.getChild("head8");
        this.torso = root.getChild("torso");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head2 = partdefinition.addOrReplaceChild("head2", CubeListBuilder.create(), PartPose.offset((float)-13.0f, (float)7.0f, (float)-8.0f));
        head2.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(32, 109).addBox(-4.3511f, -22.6056f, 7.8459f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)18.0f, (float)10.0f, (float)2.9626f, (float)-0.6423f, (float)2.937f));
        head2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(96, 95).addBox(-1.8795f, -16.2629f, 19.5477f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)13.0f, (float)18.0f, (float)10.0f, (float)-2.6477f, (float)-0.4703f, (float)2.9023f));
        PartDefinition head3 = partdefinition.addOrReplaceChild("head3", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)3.0f, (float)-10.0f));
        head3.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(109, 6).addBox(-1.9556f, -24.2196f, 5.3173f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)22.0f, (float)12.0f, (float)3.009f, (float)0.1129f, (float)-3.1296f));
        head3.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(32, 95).addBox(-0.943f, -20.2629f, 17.5242f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)22.0f, (float)12.0f, (float)-2.702f, (float)0.1186f, (float)-3.086f));
        PartDefinition head4 = partdefinition.addOrReplaceChild("head4", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)4.0f));
        head4.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(84, 81).addBox(-4.0f, -36.0006f, 11.6916f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)31.0f, (float)-2.0f, (float)-2.5744f, (float)0.0f, (float)3.1416f));
        head4.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 109).addBox(-4.0f, -31.2629f, 7.759f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)31.0f, (float)-2.0f, (float)-2.7053f, (float)0.0f, (float)3.1416f));
        PartDefinition head5 = partdefinition.addOrReplaceChild("head5", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)10.0f, (float)-6.0f));
        head5.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(104, 64).addBox(-4.4237f, -17.0446f, 9.0093f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)15.0f, (float)8.0f, (float)2.7981f, (float)1.0556f, (float)2.8826f));
        head5.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(64, 95).addBox(-4.4237f, -22.1988f, 11.24f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)15.0f, (float)8.0f, (float)2.8854f, (float)1.0556f, (float)2.8826f));
        PartDefinition head6 = partdefinition.addOrReplaceChild("head6", CubeListBuilder.create(), PartPose.offsetAndRotation((float)12.0f, (float)5.0f, (float)10.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        head6.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(0, 95).addBox(-24.9861f, -23.7525f, -6.1784f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)20.8288f, (float)-11.9819f, (float)2.6202f, (float)0.9349f, (float)2.792f));
        head6.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(104, 23).addBox(-23.5859f, -17.906f, -6.1784f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-12.0f, (float)20.8288f, (float)-11.9819f, (float)2.6734f, (float)0.9556f, (float)2.8576f));
        PartDefinition head7 = partdefinition.addOrReplaceChild("head7", CubeListBuilder.create(), PartPose.offset((float)-10.0f, (float)-4.0f, (float)11.0f));
        head7.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(0, 15).addBox(-14.6813f, -21.8139f, 19.5135f, 8.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)29.0f, (float)-9.0f, (float)-2.0567f, (float)0.2751f, (float)2.4914f));
        head7.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(108, 75).addBox(-14.6813f, -28.7175f, 14.6915f, 8.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)29.0f, (float)-9.0f, (float)-2.3622f, (float)0.2751f, (float)2.4914f));
        PartDefinition head8 = partdefinition.addOrReplaceChild("head8", CubeListBuilder.create(), PartPose.offset((float)-8.0f, (float)11.0f, (float)8.0f));
        head8.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(101, 54).addBox(-8.9696f, -17.4786f, -6.9687f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)14.0f, (float)-6.0f, (float)-0.9395f, (float)1.1447f, (float)-1.2238f));
        head8.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(80, 0).addBox(-16.9424f, -19.5751f, -6.9687f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)14.0f, (float)-6.0f, (float)0.3258f, (float)1.3104f, (float)0.0959f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        torso.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(0, 40).addBox(-13.0f, -13.0637f, -10.3502f, 26.0f, 5.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)2.0f, (float)3.1067f, (float)0.0f, (float)3.1416f));
        torso.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -25.9429f, -8.6927f, 28.0f, 16.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)2.0f, (float)-3.0543f, (float)0.0f, (float)3.1416f));
        torso.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(0, 68).addBox(-11.0f, -31.9982f, -3.8529f, 23.0f, 8.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)2.0f, (float)-2.9234f, (float)0.0f, (float)3.1416f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-13.0f, (float)-5.0f, (float)5.0f, (float)0.1309f, (float)-0.2182f, (float)0.0f));
        right_arm.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(75, 40).addBox(-7.376f, -33.7922f, -7.9359f, 15.8f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.916f, (float)28.4299f, (float)-11.9257f, (float)-2.9136f, (float)0.1298f, (float)2.6329f));
        right_arm.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(75, 53).addBox(-10.5294f, -32.7949f, -5.3264f, 11.8f, 4.0f, 4.9f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.916f, (float)28.4299f, (float)-11.9257f, (float)-2.9876f, (float)0.4358f, (float)2.1879f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)11.0f, (float)-4.4f, (float)7.6f, (float)-0.0089f, (float)0.1742f, (float)-0.0498f));
        left_arm.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(65, 68).addBox(-7.6672f, -32.9383f, -7.8704f, 15.8f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.2277f, (float)29.5507f, (float)-10.7158f, (float)-2.948f, (float)-0.0923f, (float)-2.7777f));
        left_arm.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(80, 14).addBox(-1.0144f, -31.6881f, -5.2025f, 11.8f, 4.0f, 4.9f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.2277f, (float)29.5507f, (float)-10.7158f, (float)-3.0035f, (float)-0.3873f, (float)-2.3301f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)10.0f, (float)16.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -10.0f, -1.0f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)9.0f, (float)2.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-10.0f, (float)16.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(0, 40).addBox(7.0f, -10.0f, -1.0f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)9.0f, (float)2.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(@NotNull SpitterEntityRenderState renderState) {
        this.head8.yRot = renderState.yRot / 57.295776f;
        this.head8.xRot = renderState.xRot / 57.295776f;
        this.right_arm.xRot = Mth.cos((double)(renderState.walkAnimationPos * 0.6662f + (float)Math.PI)) * renderState.walkAnimationSpeed;
        this.left_leg.xRot = Mth.cos((double)(renderState.walkAnimationPos * 1.0f)) * -1.0f * renderState.walkAnimationSpeed;
        this.left_arm.xRot = Mth.cos((double)(renderState.walkAnimationPos * 0.6662f)) * renderState.walkAnimationSpeed;
        this.right_leg.xRot = Mth.cos((double)(renderState.walkAnimationPos * 1.0f)) * 1.0f * renderState.walkAnimationSpeed;
        this.head2.yRot = renderState.yRot / 57.295776f;
        this.head2.xRot = renderState.xRot / 57.295776f;
        this.head3.yRot = renderState.yRot / 57.295776f;
        this.head3.xRot = renderState.xRot / 57.295776f;
        this.head4.yRot = renderState.yRot / 57.295776f;
        this.head4.xRot = renderState.xRot / 57.295776f;
        this.head5.yRot = renderState.yRot / 57.295776f;
        this.head5.xRot = renderState.xRot / 57.295776f;
        this.head6.yRot = renderState.yRot / 57.295776f;
        this.head6.xRot = renderState.xRot / 57.295776f;
        this.head7.yRot = renderState.yRot / 57.295776f;
        this.head7.xRot = renderState.xRot / 57.295776f;
    }
}

