/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.mutantszombies.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.villager.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.petemc.mutantszombies.config.Config;
import net.petemc.mutantszombies.sound.ModSounds;
import org.jetbrains.annotations.NotNull;

public class MutantBruteEntity
extends Monster {
    private int attackTicksLeft;
    private int treeBreakCooldown = 40;

    public MutantBruteEntity(EntityType<MutantBruteEntity> type, Level world) {
        super(type, world);
        this.xpReward = 16;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{MutantBruteEntity.class}).setAlertOthers(new Class[]{MutantBruteEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, true));
        this.registerCustomGoals();
    }

    protected void registerCustomGoals() {
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
    }

    public SoundEvent getAmbientSound() {
        return ModSounds.ROAR_SOUND.get();
    }

    public void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound((SoundEvent)((Holder.Reference)BuiltInRegistries.SOUND_EVENT.get(Identifier.parse((String)"block.rooted_dirt.step")).orElseThrow()).value(), 0.15f, 1.0f);
    }

    @NotNull
    public SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)((Holder.Reference)BuiltInRegistries.SOUND_EVENT.get(Identifier.parse((String)"entity.husk.hurt")).orElseThrow()).value();
    }

    @NotNull
    public SoundEvent getDeathSound() {
        return (SoundEvent)((Holder.Reference)BuiltInRegistries.SOUND_EVENT.get(Identifier.parse((String)"entity.zombie.death")).orElseThrow()).value();
    }

    public boolean hurtServer(@NotNull ServerLevel serverLevel, DamageSource damageSource, float amount) {
        if (damageSource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damageSource.is(DamageTypes.WITHER)) {
            return false;
        }
        return super.hurtServer(serverLevel, damageSource, amount);
    }

    public int getAttackAnimationTick() {
        return this.attackTicksLeft;
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackTicksLeft > 0) {
            --this.attackTicksLeft;
        }
    }

    public boolean doHurtTarget(@NotNull ServerLevel serverLevel, @NotNull Entity target) {
        boolean bl = super.doHurtTarget(serverLevel, target);
        this.attackTicksLeft = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        return bl;
    }

    public void handleEntityEvent(byte status) {
        if (status == 4) {
            this.attackTicksLeft = 10;
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleEntityEvent(status);
        }
    }

    public void tick() {
        super.tick();
        if (Config.getMutantBrutesBreakLogsAndLeavesAroundThem()) {
            if (this.treeBreakCooldown > 0) {
                --this.treeBreakCooldown;
            } else if (!this.level().isClientSide()) {
                this.treeBreakCooldown = 40;
                AABB box = new AABB(this.position(), this.position());
                box = box.inflate(3.0);
                box = box.inflate(0.0, 1.0, 0.0);
                BlockPos.MutableBlockPos.betweenClosedStream((AABB)box).filter(c -> this.level().getBlockState(c).getBlock().toString().contains("leaves") || this.level().getBlockState(c).getBlock().toString().contains("log")).forEach(c -> {
                    String blockName = this.level().getBlockState(c).getBlock().toString();
                    if (!blockName.contains("securitycraft") || !blockName.contains("reinforced")) {
                        if (blockName.contains("leaves")) {
                            this.level().destroyBlock(c, false);
                        }
                        if (blockName.contains("log")) {
                            this.level().destroyBlock(c, true);
                        }
                    }
                });
            }
        }
    }

    public static boolean checkMutantBruteSpawnRules(EntityType<MutantBruteEntity> mutantBruteEntityType, ServerLevelAccessor serverLevel, EntitySpawnReason entitySpawnReason, BlockPos pos, RandomSource random) {
        return Config.getMutantBrutesSpawnNaturally() && !serverLevel.getBiome(pos).is(Biomes.MUSHROOM_FIELDS) && !serverLevel.getBiome(pos).is(Biomes.DEEP_DARK) && serverLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules(mutantBruteEntityType, (LevelAccessor)serverLevel, (EntitySpawnReason)entitySpawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 18.0).add(Attributes.ARMOR, 18.0).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }
}

