/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.BatFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.BatFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BatFamiliarRenderer
extends MobRenderer<BatFamiliarEntity, BatFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/bat_familiar.png");

    public BatFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BatFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_BAT)), 0.3f);
    }

    public void render(BatFamiliarEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        if (!entityIn.isSitting() || entityIn.isPartying()) {
            poseStack.translate(0.0, (double)entityIn.getAnimationHeight(partialTicks) * 0.1 + (double)0.1f, 0.0);
        }
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(BatFamiliarEntity entity) {
        return TEXTURES;
    }
}

