/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.google.common.collect.ImmutableMap;
import com.klikli_dev.occultism.client.model.entity.CthulhuFamiliarModel;
import com.klikli_dev.occultism.client.model.entity.HeadlessFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.HeadlessFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class HeadlessFamiliarRenderer
extends MobRenderer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/headless_familiar.png");

    public HeadlessFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HeadlessFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_HEADLESS)), 0.3f);
        this.addLayer(new HeadLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.addLayer(new WeaponLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.addLayer(new RebuiltLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
        this.addLayer(new PumpkinLayer((RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(HeadlessFamiliarEntity entity) {
        return TEXTURE;
    }

    public void render(HeadlessFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        if (pEntity.isSitting()) {
            pMatrixStack.translate(0.0, -0.12, 0.0);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.popPose();
    }

    public static class HeadLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        private static Map<EntityType<?>, ResourceLocation> textures;
        private static Map<EntityType<?>, SkullModelBase> skulls;

        public HeadLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> parent) {
            super(parent);
        }

        private static ResourceLocation getTexture(EntityType<?> type) {
            if (textures == null) {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)EntityType.PLAYER, (Object)DefaultPlayerSkin.getDefaultTexture());
                builder.put((Object)EntityType.SKELETON, (Object)ResourceLocation.parse((String)"textures/entity/skeleton/skeleton.png"));
                builder.put((Object)EntityType.WITHER_SKELETON, (Object)ResourceLocation.parse((String)"textures/entity/skeleton/wither_skeleton.png"));
                builder.put((Object)EntityType.STRAY, (Object)ResourceLocation.parse((String)"textures/entity/skeleton/stray.png"));
                builder.put((Object)EntityType.BOGGED, (Object)ResourceLocation.parse((String)"textures/entity/skeleton/bogged_overlay.png"));
                builder.put((Object)EntityType.ZOMBIE, (Object)ResourceLocation.parse((String)"textures/entity/zombie/zombie.png"));
                builder.put((Object)EntityType.HUSK, (Object)ResourceLocation.parse((String)"textures/entity/zombie/husk.png"));
                builder.put((Object)EntityType.DROWNED, (Object)ResourceLocation.parse((String)"textures/entity/zombie/drowned_outer_layer.png"));
                builder.put((Object)EntityType.CREEPER, (Object)ResourceLocation.parse((String)"textures/entity/creeper/creeper.png"));
                builder.put((Object)EntityType.SPIDER, (Object)ResourceLocation.parse((String)"textures/entity/spider/spider.png"));
                builder.put((Object)EntityType.CAVE_SPIDER, (Object)ResourceLocation.parse((String)"textures/entity/spider/cave_spider.png"));
                builder.put((Object)EntityType.PIGLIN, (Object)ResourceLocation.parse((String)"textures/entity/piglin/piglin.png"));
                builder.put((Object)EntityType.PIGLIN_BRUTE, (Object)ResourceLocation.parse((String)"textures/entity/piglin/piglin_brute.png"));
                builder.put((Object)EntityType.ZOMBIFIED_PIGLIN, (Object)ResourceLocation.parse((String)"textures/entity/piglin/zombified_piglin.png"));
                builder.put((Object)EntityType.BLAZE, (Object)ResourceLocation.parse((String)"textures/entity/blaze.png"));
                builder.put((Object)EntityType.BREEZE, (Object)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/breeze_blaze_size.png"));
                builder.put((Object)EntityType.ENDERMAN, (Object)ResourceLocation.parse((String)"textures/entity/enderman/enderman.png"));
                builder.put((Object)EntityType.ENDER_DRAGON, (Object)ResourceLocation.parse((String)"textures/entity/enderdragon/dragon.png"));
                builder.put(OccultismEntities.CTHULHU_FAMILIAR.get(), (Object)ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/cthulhu_familiar.png"));
                builder.put((Object)EntityType.VILLAGER, (Object)ResourceLocation.parse((String)"textures/entity/villager/villager.png"));
                builder.put((Object)EntityType.WANDERING_TRADER, (Object)ResourceLocation.parse((String)"textures/entity/wandering_trader.png"));
                builder.put((Object)EntityType.ZOMBIE_VILLAGER, (Object)ResourceLocation.parse((String)"textures/entity/zombie_villager/zombie_villager.png"));
                builder.put((Object)EntityType.WITCH, (Object)ResourceLocation.parse((String)"textures/entity/witch.png"));
                builder.put((Object)EntityType.PILLAGER, (Object)ResourceLocation.parse((String)"textures/entity/illager/pillager.png"));
                builder.put((Object)EntityType.VINDICATOR, (Object)ResourceLocation.parse((String)"textures/entity/illager/vindicator.png"));
                builder.put((Object)EntityType.EVOKER, (Object)ResourceLocation.parse((String)"textures/entity/illager/evoker.png"));
                textures = builder.build();
            }
            return textures.get(type);
        }

        private static SkullModelBase getHeadModel(EntityType<?> type) {
            if (skulls == null) {
                EntityModelSet entityModels = Minecraft.getInstance().getEntityModels();
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)EntityType.SKELETON, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.SKELETON_SKULL)));
                builder.put((Object)EntityType.WITHER_SKELETON, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.WITHER_SKELETON_SKULL)));
                builder.put((Object)EntityType.STRAY, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.SKELETON_SKULL)));
                builder.put((Object)EntityType.BOGGED, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.BOGGED)));
                builder.put((Object)EntityType.PLAYER, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.PLAYER_HEAD)));
                builder.put((Object)EntityType.ZOMBIE, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.ZOMBIE_HEAD)));
                builder.put((Object)EntityType.HUSK, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.ZOMBIE_HEAD)));
                builder.put((Object)EntityType.DROWNED, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.DROWNED)));
                builder.put((Object)EntityType.CREEPER, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.CREEPER_HEAD)));
                builder.put((Object)EntityType.SPIDER, (Object)new SpiderHeadModel(entityModels.bakeLayer(ModelLayers.SPIDER)));
                builder.put((Object)EntityType.CAVE_SPIDER, (Object)new SpiderHeadModel(entityModels.bakeLayer(ModelLayers.CAVE_SPIDER)));
                builder.put((Object)EntityType.PIGLIN, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.PIGLIN_HEAD)));
                builder.put((Object)EntityType.PIGLIN_BRUTE, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.PIGLIN_HEAD)));
                builder.put((Object)EntityType.ZOMBIFIED_PIGLIN, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.PIGLIN_HEAD)));
                builder.put((Object)EntityType.BLAZE, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.BLAZE)));
                builder.put((Object)EntityType.BREEZE, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.BLAZE)));
                builder.put((Object)EntityType.ENDERMAN, (Object)new EndermanHeadModel(entityModels.bakeLayer(ModelLayers.ENDERMAN)));
                builder.put((Object)EntityType.ENDER_DRAGON, (Object)new SkullModel(entityModels.bakeLayer(ModelLayers.DRAGON_SKULL)));
                builder.put(OccultismEntities.CTHULHU_FAMILIAR.get(), (Object)new CthulhuHeadModel(entityModels.bakeLayer(OccultismModelLayers.FAMILIAR_CTHULHU)));
                builder.put((Object)EntityType.VILLAGER, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.VILLAGER)));
                builder.put((Object)EntityType.WANDERING_TRADER, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.WANDERING_TRADER)));
                builder.put((Object)EntityType.ZOMBIE_VILLAGER, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.ZOMBIE_VILLAGER)));
                builder.put((Object)EntityType.WITCH, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.WITCH)));
                builder.put((Object)EntityType.PILLAGER, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.PILLAGER)));
                builder.put((Object)EntityType.VINDICATOR, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.VINDICATOR)));
                builder.put((Object)EntityType.EVOKER, (Object)new OnlyHeadModel(entityModels.bakeLayer(ModelLayers.EVOKER)));
                skulls = builder.build();
            }
            return skulls.get(type);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, HeadlessFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isHeadlessDead()) {
                return;
            }
            EntityType<? extends LivingEntity> headType = pLivingEntity.getHeadType();
            if (headType == null) {
                return;
            }
            SkullModelBase head = HeadLayer.getHeadModel(headType);
            if (head == null) {
                return;
            }
            pMatrixStack.pushPose();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.getParentModel();
            model.ratBody1.translateAndRotate(pMatrixStack);
            model.body.translateAndRotate(pMatrixStack);
            model.leftArm.translateAndRotate(pMatrixStack);
            float size = 0.5f;
            pMatrixStack.scale(size, size, size);
            pMatrixStack.translate(0.15, 0.5, -0.12);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(1.5707964f, 0.0f, 0.0f));
            ResourceLocation texture = HeadLayer.getTexture(headType);
            if (texture != null) {
                VertexConsumer builder = pBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture));
                head.renderToBuffer(pMatrixStack, builder, pPackedLight, OverlayTexture.NO_OVERLAY);
            }
            pMatrixStack.popPose();
        }
    }

    private static class WeaponLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        public WeaponLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, HeadlessFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isHeadlessDead()) {
                return;
            }
            pMatrixStack.pushPose();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.getParentModel();
            model.ratBody1.translateAndRotate(pMatrixStack);
            model.body.translateAndRotate(pMatrixStack);
            model.rightArm.translateAndRotate(pMatrixStack);
            pMatrixStack.translate((double)-0.05f, 0.16, -0.08);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 1.5707964f, -0.87266463f));
            Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem((LivingEntity)pLivingEntity, pLivingEntity.getWeaponItem(), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.popPose();
        }
    }

    private static class RebuiltLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        public RebuiltLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack matrix, MultiBufferSource bufferIn, int packedLightIn, HeadlessFamiliarEntity headless, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float ageInTicks, float netHeadYaw, float pHeadPitch) {
            if (!headless.isHeadlessDead()) {
                return;
            }
            ItemInHandRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer();
            matrix.pushPose();
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.getParentModel();
            model.ratBody1.translateAndRotate(matrix);
            boolean partying = headless.isPartying();
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.RightLeg)) {
                matrix.pushPose();
                matrix.mulPose(new Quaternionf().rotateXYZ(0.0f, 2.268928f, 0.0f));
                matrix.translate(0.3, -0.3, 0.0);
                this.renderItem(Items.WHEAT, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.popPose();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.LeftLeg)) {
                matrix.pushPose();
                matrix.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.87266463f, 0.0f));
                matrix.translate(0.3, -0.3, 0.0);
                this.renderItem(Items.WHEAT, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.popPose();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.Body)) {
                matrix.pushPose();
                float size = 1.2f;
                matrix.scale(size, size, size);
                matrix.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.0f, 0.0f));
                matrix.translate(0.0, -0.45, -0.05);
                this.renderItem(Items.HAY_BLOCK, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.translate(0.0, -0.25, 0.0);
                this.renderItem(Items.HAY_BLOCK, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.popPose();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.RightArm)) {
                matrix.pushPose();
                matrix.mulPose(new Quaternionf().rotateXYZ(0.0f, (180.0f + (partying ? Mth.sin((float)(ageInTicks / 3.0f)) * 20.0f : 0.0f)) * ((float)Math.PI / 180), 0.0f));
                matrix.translate(0.25, -0.6, 0.05);
                this.renderItem(Items.STICK, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.popPose();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.LeftArm)) {
                matrix.pushPose();
                matrix.mulPose(new Quaternionf().rotateXYZ(0.0f, (partying ? Mth.sin((float)(ageInTicks / 3.0f)) * 20.0f : 0.0f) * ((float)Math.PI / 180), 0.0f));
                matrix.translate(0.25, -0.6, -0.05);
                this.renderItem(Items.STICK, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.popPose();
            }
            if (headless.isRebuilt(HeadlessFamiliarEntity.Rebuilt.Head)) {
                matrix.pushPose();
                matrix.scale(-1.0f, -1.0f, 1.0f);
                matrix.translate(0.0, 0.7, -0.06);
                matrix.mulPose(new Quaternionf().rotateXYZ(0.0f, (partying ? ageInTicks * 8.0f : -netHeadYaw) * ((float)Math.PI / 180), 0.0f));
                this.renderItem(Items.CARVED_PUMPKIN, matrix, bufferIn, packedLightIn, headless, renderer);
                matrix.popPose();
            }
            matrix.popPose();
        }

        private void renderItem(Item item, PoseStack pMatrixStack, MultiBufferSource bufferIn, int packedLightIn, HeadlessFamiliarEntity pLivingEntity, ItemInHandRenderer renderer) {
            renderer.renderItem((LivingEntity)pLivingEntity, new ItemStack((ItemLike)item), ItemDisplayContext.GROUND, false, pMatrixStack, bufferIn, packedLightIn);
        }
    }

    private static class PumpkinLayer
    extends RenderLayer<HeadlessFamiliarEntity, HeadlessFamiliarModel> {
        private static final ResourceLocation PUMPKIN = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/headless_familiar_pumpkin.png");
        private static final ResourceLocation CHRISTMAS = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/headless_familiar_christmas.png");

        public PumpkinLayer(RenderLayerParent<HeadlessFamiliarEntity, HeadlessFamiliarModel> renderer) {
            super(renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, HeadlessFamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isInvisible()) {
                return;
            }
            boolean isChristmas = FamiliarUtil.isChristmas();
            boolean hasPumpkin = !entitylivingbaseIn.hasHead();
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)(isChristmas ? CHRISTMAS : PUMPKIN)));
            HeadlessFamiliarModel model = (HeadlessFamiliarModel)this.getParentModel();
            model.pumpkin1.visible = hasPumpkin;
            model.snowmanHat1.visible = isChristmas;
            model.snowmanHat2.visible = isChristmas;
            model.snowmanLeftEye.visible = isChristmas;
            model.snowmanRightEye.visible = isChristmas;
            model.snowmanMouth1.visible = isChristmas;
            model.snowmanMouth2.visible = isChristmas;
            model.snowmanMouth3.visible = isChristmas;
            model.snowmanNose.visible = isChristmas;
            model.pumpkin2.visible = !isChristmas;
            model.pumpkin3.visible = !isChristmas;
            model.pumpkin4.visible = !isChristmas;
            model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f));
        }
    }

    private static class SpiderHeadModel
    extends SkullModelBase {
        protected final ModelPart head;

        public SpiderHeadModel(ModelPart root) {
            this.head = root.getChild("head");
        }

        public void setupAnim(float p_103811_, float p_103812_, float p_103813_) {
            this.head.yRot = p_103812_ * ((float)Math.PI / 180);
            this.head.xRot = p_103813_ * ((float)Math.PI / 180);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            poseStack.translate(0.0, -1.1, 0.3);
            this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    private static class EndermanHeadModel
    extends SkullModelBase {
        protected final ModelPart head;

        public EndermanHeadModel(ModelPart root) {
            this.head = root.getChild("head");
        }

        public void setupAnim(float p_103811_, float p_103812_, float p_103813_) {
            this.head.yRot = p_103812_ * ((float)Math.PI / 180);
            this.head.xRot = p_103813_ * ((float)Math.PI / 180);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            poseStack.translate(0.0, 0.9, 0.0);
            this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    private static class OnlyHeadModel
    extends SkullModelBase {
        protected final ModelPart head;

        public OnlyHeadModel(ModelPart root) {
            this.head = root.getChild("head");
        }

        public void setupAnim(float p_103811_, float p_103812_, float p_103813_) {
            this.head.yRot = p_103812_ * ((float)Math.PI / 180);
            this.head.xRot = p_103813_ * ((float)Math.PI / 180);
        }

        public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
            this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    private static class CthulhuHeadModel
    extends SkullModelBase {
        protected final ModelPart head;
        private final CthulhuFamiliarModel model;

        public CthulhuHeadModel(ModelPart part) {
            this.model = new CthulhuFamiliarModel(part);
            this.head = part.getChild("body").getChild("head");
        }

        public void renderToBuffer(PoseStack pMatrixStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
            this.model.trunk1.visible = false;
            this.model.trunk2.visible = false;
            this.model.trunk3.visible = false;
            this.model.hat1.visible = false;
            pMatrixStack.pushPose();
            pMatrixStack.scale(1.5f, 1.5f, 1.5f);
            pMatrixStack.translate(0.0, 0.35, 0.07);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.17453292f, 0.0f, 0.0f));
            this.model.head.render(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay);
            pMatrixStack.popPose();
        }

        public void setupAnim(float p_103811_, float p_103812_, float p_103813_) {
            this.head.yRot = p_103812_ * ((float)Math.PI / 180);
            this.head.xRot = p_103813_ * ((float)Math.PI / 180);
        }
    }
}

