/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.EnumUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class RainbowGlyphBlock
extends ChalkGlyphBlock {
    public static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)4, (int)15);
    public static final BooleanProperty CYCLE = BooleanProperty.create((String)"cycle");
    protected Supplier<Item> chalk;
    protected Supplier<Integer> color;
    protected Boolean cycle;

    public RainbowGlyphBlock(BlockBehaviour.Properties properties, Boolean cycle, Supplier<Item> chalk) {
        super(properties, (Supplier<Integer>)Occultism.CLIENT_CONFIG.visuals.whiteChalkGlyphColor, chalk);
        this.chalk = chalk;
        this.cycle = cycle;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CYCLE, (Comparable)cycle));
    }

    public int getColor(BlockState state) {
        return EnumUtil.getConfiguredColor((Integer)state.getValue((Property)COLOR));
    }

    @Override
    public Item getChalk() {
        return this.chalk.get();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Player player;
        BlockPos pos = context.getClickedPos();
        int sign = context.getLevel().getRandom().nextInt(14);
        int cor = RandomSource.create().nextIntBetweenInclusive(4, 15);
        boolean cc = this.cycle;
        BlockState current = context.getLevel().getBlockState(pos);
        if (current.getBlock() == this) {
            sign = ((Integer)current.getValue((Property)SIGN) + 1) % 14;
            cor = (Integer)current.getValue((Property)COLOR);
            cc = (Boolean)current.getValue((Property)CYCLE);
        }
        if ((player = context.getPlayer()) != null) {
            ItemStack stack;
            ItemStack itemStack = stack = context.getHand().equals((Object)InteractionHand.MAIN_HAND) ? player.getItemInHand(InteractionHand.OFF_HAND) : player.getItemInHand(InteractionHand.MAIN_HAND);
            if (stack.is(Tags.Items.DYES_BROWN)) {
                cor = 4;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_RED)) {
                cor = 5;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_ORANGE)) {
                cor = 6;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_YELLOW)) {
                cor = 7;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_LIME)) {
                cor = 8;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_GREEN)) {
                cor = 9;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_CYAN)) {
                cor = 10;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_LIGHT_BLUE)) {
                cor = 11;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_BLUE)) {
                cor = 12;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_PURPLE)) {
                cor = 13;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_MAGENTA)) {
                cor = 14;
                cc = false;
            } else if (stack.is(Tags.Items.DYES_PINK)) {
                cor = 15;
                cc = false;
            } else if (stack.is(OccultismItems.SPIRIT_ATTUNED_GEM)) {
                cc = false;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(cor))).setValue((Property)CYCLE, (Comparable)Boolean.valueOf(cc))).setValue((Property)SIGN, (Comparable)Integer.valueOf(sign))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, CYCLE});
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild) {
            if (stack.getItem().equals(OccultismItems.SPIRIT_ATTUNED_GEM.get())) {
                if (((Boolean)state.getValue((Property)CYCLE)).booleanValue()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CYCLE, (Comparable)Boolean.valueOf(false)));
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CYCLE, (Comparable)Boolean.valueOf(true)));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_BROWN)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(4)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_RED)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(5)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_ORANGE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(6)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_YELLOW)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(7)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_LIME)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(8)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_GREEN)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(9)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_CYAN)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(10)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_LIGHT_BLUE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(11)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_BLUE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(12)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_PURPLE)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(13)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_MAGENTA)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(14)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getTags().toList().contains(Tags.Items.DYES_PINK)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(15)));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void animateTick(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)state.getValue((Property)CYCLE)).booleanValue()) {
            int nextColor = (Integer)state.getValue((Property)COLOR) == 15 ? 4 : (Integer)state.getValue((Property)COLOR) + 1;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(nextColor)));
        }
    }
}

