/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.ai.sensor.NearestCropSensor;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public class HarvestCropBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double HARVEST_CROP_RANGE_SQUARE = Math.pow(2.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.NEAREST_CROP.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    public HarvestCropBehaviour() {
        this.runtimeProvider = entity -> 20;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        BlockPos cropPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
        double dist = cropPos != null ? entity.distanceToSqr(Vec3.atCenterOf((Vec3i)cropPos)) : 0.0;
        return dist <= HARVEST_CROP_RANGE_SQUARE;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
    }

    protected void tick(E entity) {
        BlockPos cropPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
        if (cropPos == null) {
            return;
        }
        if (NearestCropSensor.isGrowthCrop(entity.level(), cropPos)) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(cropPos));
            entity.swing(InteractionHand.MAIN_HAND, true);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    CropBlock cropBlock;
                    BlockState state = entity.level().getBlockState(cropPos.offset(x, 0, z));
                    Block block = state.getBlock();
                    if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).isMaxAge(state)) continue;
                    entity.playSound(SoundEvents.CROP_BREAK, 1.0f, 1.0f);
                    entity.level().destroyBlock(cropPos.offset(x, 0, z), true);
                    entity.level().setBlock(cropPos.offset(x, 0, z), cropBlock.defaultBlockState(), 1);
                }
            }
            this.stop((ServerLevel)entity.level(), (LivingEntity)entity, entity.level().getGameTime());
        } else {
            this.stop((ServerLevel)entity.level(), (LivingEntity)entity, entity.level().getGameTime());
        }
    }

    protected void stop(E entity) {
        BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
    }
}

