/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class ColoredFamiliarEntity
extends FamiliarEntity {
    private static final EntityDataAccessor<Float> RED = SynchedEntityData.defineId(ColoredFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> GREEN = SynchedEntityData.defineId(ColoredFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BLUE = SynchedEntityData.defineId(ColoredFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public ColoredFamiliarEntity(EntityType<? extends ColoredFamiliarEntity> type, Level level) {
        super(type, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RED, (Object)Float.valueOf(0.0f));
        builder.define(GREEN, (Object)Float.valueOf(0.0f));
        builder.define(BLUE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setRed(compound.getFloat("red"));
        this.setGreen(compound.getFloat("green"));
        this.setBlue(compound.getFloat("blue"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("red", this.getRed());
        compound.putFloat("green", this.getGreen());
        compound.putFloat("blue", this.getBlue());
    }

    public float getRed() {
        return ((Float)this.entityData.get(RED)).floatValue();
    }

    private void setRed(float f) {
        this.entityData.set(RED, (Object)Float.valueOf(f));
    }

    public float getGreen() {
        return ((Float)this.entityData.get(GREEN)).floatValue();
    }

    private void setGreen(float f) {
        this.entityData.set(GREEN, (Object)Float.valueOf(f));
    }

    public float getBlue() {
        return ((Float)this.entityData.get(BLUE)).floatValue();
    }

    private void setBlue(float f) {
        this.entityData.set(BLUE, (Object)Float.valueOf(f));
    }

    protected void setColor() {
        RandomSource rand = this.getRandom();
        for (int i = 0; i < 20; ++i) {
            float r = rand.nextFloat();
            float g = rand.nextFloat();
            float b = rand.nextFloat();
            if (!(Mth.abs((float)(r - g)) > 0.2f) && !(Mth.abs((float)(r - b)) > 0.2f) && !(Mth.abs((float)(g - b)) > 0.2f)) continue;
            this.setRed(r);
            this.setGreen(g);
            this.setBlue(b);
            return;
        }
    }
}

