/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class UnbreakableRitual
extends Ritual {
    public UnbreakableRitual(RitualRecipe recipe) {
        super(recipe);
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        super.finish(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem);
        ItemStack result = activationItem.copy();
        activationItem.shrink(1);
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.5, (double)goldenBowlPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        result.setDamageValue(0);
        result.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
        if (result.isEnchanted()) {
            EnchantmentHelper.updateEnchantments((ItemStack)result, p_330066_ -> p_330066_.removeIf(p_344368_ -> p_344368_.is(Enchantments.UNBREAKING)));
            EnchantmentHelper.updateEnchantments((ItemStack)result, p_330066_ -> p_330066_.removeIf(p_344368_ -> p_344368_.is(Enchantments.MENDING)));
        }
        result.set(DataComponents.RARITY, (Object)Rarity.EPIC);
        result.set(DataComponents.CUSTOM_NAME, (Object)Component.empty().append(String.valueOf(ChatFormatting.OBFUSCATED) + "nice   " + String.valueOf(ChatFormatting.RESET)).append(result.getHoverName()).append(String.valueOf(ChatFormatting.OBFUSCATED) + "   ecin" + String.valueOf(ChatFormatting.RESET)));
        this.dropResult(level, goldenBowlPosition, blockEntity, (Player)castingPlayer, result, true);
    }
}

