/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.crafting.recipe.SingleInputRecipe;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpiritFireRecipe
extends SingleInputRecipe<SingleRecipeInput> {
    public static final MapCodec<SpiritFireRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.input), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(r -> r.output)).apply((Applicative)instance, SpiritFireRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpiritFireRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.output, SpiritFireRecipe::new);
    public static Serializer SERIALIZER = new Serializer();

    public SpiritFireRecipe(Ingredient input, ItemStack output) {
        super(input, output);
    }

    public boolean isSpecial() {
        return true;
    }

    @Override
    public boolean matches(SingleRecipeInput inv, Level level) {
        return this.input.test(inv.getItem(0));
    }

    @Override
    public ItemStack assemble(SingleRecipeInput pCraftingContainer, HolderLookup.Provider pRegistries) {
        ItemStack result = this.getResultItem(pRegistries).copy();
        result.setCount(pCraftingContainer.getItem(0).getCount());
        return result;
    }

    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.output;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.input});
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)OccultismBlocks.SPIRIT_FIRE.get());
    }

    public RecipeType<?> getType() {
        return (RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SpiritFireRecipe> {
        public MapCodec<SpiritFireRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SpiritFireRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

