/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageAccessor;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.api.common.data.SortDirection;
import com.klikli_dev.occultism.api.common.data.SortType;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MessageSortItems
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"sort_items");
    public static final CustomPacketPayload.Type<MessageSortItems> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSortItems> STREAM_CODEC = CustomPacketPayload.codec(MessageSortItems::encode, MessageSortItems::new);
    private BlockPos entityPosition;
    private SortDirection sortDirection;
    private SortType sortType;

    public MessageSortItems(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSortItems(BlockPos entityPosition, SortDirection sortDirection, SortType sortType) {
        this.entityPosition = entityPosition;
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (player.containerMenu instanceof IStorageControllerContainer) {
            if (!((IStorageControllerContainer)player.containerMenu).isContainerItem()) {
                if (!player.level().hasChunkAt(this.entityPosition)) {
                    return;
                }
                BlockEntity blockEntity = player.level().getBlockEntity(this.entityPosition);
                if (blockEntity instanceof IStorageAccessor) {
                    IStorageAccessor storageAccessor = (IStorageAccessor)blockEntity;
                    storageAccessor.setSortType(this.sortType);
                    storageAccessor.setSortDirection(this.sortDirection);
                    blockEntity.setChanged();
                }
            } else {
                ItemStack stack = player.getInventory().getSelected();
                stack.set(OccultismDataComponents.SORT_DIRECTION, (Object)this.sortDirection);
                stack.set(OccultismDataComponents.SORT_TYPE, (Object)this.sortType);
            }
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf byteBuf) {
        byteBuf.writeBlockPos(this.entityPosition);
        SortDirection.STREAM_CODEC.encode((Object)byteBuf, (Object)this.sortDirection);
        SortType.STREAM_CODEC.encode((Object)byteBuf, (Object)this.sortType);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf byteBuf) {
        this.entityPosition = byteBuf.readBlockPos();
        this.sortDirection = (SortDirection)((Object)SortDirection.STREAM_CODEC.decode((Object)byteBuf));
        this.sortType = (SortType)((Object)SortType.STREAM_CODEC.decode((Object)byteBuf));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

