/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;

public class InteractWithDoor<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(3).hasMemory(MemoryModuleType.PATH).usesMemories(MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.NEAREST_LIVING_ENTITIES);
    protected ToIntFunction<E> doorInteractionDelay = entity -> 20;
    protected TriPredicate<E, LivingEntity, BlockPos> holdDoorsOpenFor = (entity, other, doorPos) -> entity.getType() == other.getType() && doorPos.closerToCenterThan((Position)other.position(), 2.0);
    protected int doorCloseCooldown = -1;
    protected Node lastNode = null;

    public InteractWithDoor<E> holdDoorsOpenFor(TriPredicate<E, LivingEntity, BlockPos> predicate) {
        this.holdDoorsOpenFor = predicate;
        return this;
    }

    public InteractWithDoor<E> doorInteractionDelay(ToIntFunction<E> delay) {
        this.doorInteractionDelay = delay;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Path path = (Path)BrainUtils.getMemory(entity, MemoryModuleType.PATH);
        return !path.notStarted() && !path.isDone();
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, MemoryModuleType.PATH) && this.checkExtraStartConditions((ServerLevel)entity.level(), entity);
    }

    @Override
    protected void tick(E entity) {
        ServerLevel level = (ServerLevel)entity.level();
        Path path = (Path)BrainUtils.getMemory(entity, MemoryModuleType.PATH);
        BlockPos prevNodePos = path.getPreviousNode().asBlockPos();
        BlockPos nextNodePos = path.getNextNode().asBlockPos();
        BlockState prevNodeBlockState = level.getBlockState(prevNodePos);
        BlockState nextNodeBlockState = level.getBlockState(nextNodePos);
        if (this.doorCloseCooldown < 0) {
            this.doorCloseCooldown = this.doorInteractionDelay.applyAsInt(entity);
            this.lastNode = path.getNextNode();
        }
        if (!Objects.equals(this.lastNode, path.getNextNode()) && --this.doorCloseCooldown < 0) {
            return;
        }
        BrainUtils.withMemory(entity, MemoryModuleType.DOORS_TO_CLOSE, doorsToClose -> this.checkAndCloseDoors(level, entity, (Set<GlobalPos>)doorsToClose, prevNodePos, nextNodePos));
        if (this.isInteractableDoor(prevNodeBlockState)) {
            this.tryOpenDoor(level, entity, prevNodeBlockState, prevNodePos);
        }
        if (this.isInteractableDoor(nextNodeBlockState)) {
            this.tryOpenDoor(level, entity, nextNodeBlockState, nextNodePos);
        }
    }

    protected void checkAndCloseDoors(ServerLevel level, E entity, Set<GlobalPos> doorsToClose, BlockPos prevNodePos, BlockPos nextNodePos) {
        Iterator<GlobalPos> iterator = doorsToClose.iterator();
        while (iterator.hasNext()) {
            DoorBlock doorBlock;
            GlobalPos doorLocation = iterator.next();
            BlockPos doorPos = doorLocation.pos();
            if (doorPos.equals((Object)prevNodePos) || doorPos.equals((Object)nextNodePos)) continue;
            if (doorLocation.dimension() != level.dimension() || !doorPos.closerToCenterThan((Position)entity.position(), 3.0)) {
                iterator.remove();
                continue;
            }
            BlockState doorState = level.getBlockState(doorPos);
            if (this.isInteractableDoor(doorState) && (doorBlock = (DoorBlock)doorState.getBlock()).isOpen(doorState) && !this.shouldHoldDoorOpenForOthers(entity, doorPos, BrainUtils.memoryOrDefault(entity, MemoryModuleType.NEAREST_LIVING_ENTITIES, List::of))) {
                doorBlock.setOpen(entity, (Level)level, doorState, doorPos, false);
            }
            iterator.remove();
        }
    }

    protected boolean shouldHoldDoorOpenForOthers(E entity, BlockPos doorPos, List<LivingEntity> others) {
        for (LivingEntity other : others) {
            Path path;
            if (!this.holdDoorsOpenFor.test(entity, other, doorPos) || (path = (Path)BrainUtils.getMemory(entity, MemoryModuleType.PATH)) == null || path.isDone() || path.notStarted() || !path.getPreviousNode().asBlockPos().equals((Object)doorPos) && !path.getNextNode().asBlockPos().equals((Object)doorPos)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInteractableDoor(BlockState state) {
        return state.is(BlockTags.MOB_INTERACTABLE_DOORS) && state.getBlock() instanceof DoorBlock;
    }

    protected void tryOpenDoor(ServerLevel level, E entity, BlockState blockState, BlockPos pos) {
        DoorBlock door = (DoorBlock)blockState.getBlock();
        if (!door.isOpen(blockState)) {
            door.setOpen(entity, (Level)level, blockState, pos, true);
            Set doorPositions = (Set)BrainUtils.getMemory(entity, MemoryModuleType.DOORS_TO_CLOSE);
            if (doorPositions == null) {
                doorPositions = new ObjectOpenHashSet();
            }
            doorPositions.add(new GlobalPos(level.dimension(), pos));
        }
    }
}

