/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.boh;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.boh.init.BohModBlockEntities;
import net.mcreator.boh.init.BohModBlocks;
import net.mcreator.boh.init.BohModEnchantments;
import net.mcreator.boh.init.BohModEntities;
import net.mcreator.boh.init.BohModItems;
import net.mcreator.boh.init.BohModMenus;
import net.mcreator.boh.init.BohModMobEffects;
import net.mcreator.boh.init.BohModPaintings;
import net.mcreator.boh.init.BohModParticleTypes;
import net.mcreator.boh.init.BohModPotions;
import net.mcreator.boh.init.BohModSounds;
import net.mcreator.boh.init.BohModTabs;
import net.mcreator.boh.init.BohModVillagerProfessions;
import net.mcreator.boh.world.features.StructureFeature;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="boh")
public class BohMod {
    public static final Logger LOGGER = LogManager.getLogger(BohMod.class);
    public static final String MODID = "boh";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("boh", "boh"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public BohMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BohModSounds.REGISTRY.register(bus);
        BohModBlocks.REGISTRY.register(bus);
        BohModBlockEntities.REGISTRY.register(bus);
        BohModItems.REGISTRY.register(bus);
        BohModEntities.REGISTRY.register(bus);
        BohModEnchantments.REGISTRY.register(bus);
        BohModTabs.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        BohModMobEffects.REGISTRY.register(bus);
        BohModPotions.REGISTRY.register(bus);
        BohModPaintings.REGISTRY.register(bus);
        BohModParticleTypes.REGISTRY.register(bus);
        BohModVillagerProfessions.PROFESSIONS.register(bus);
        BohModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

