/*
 * Decompiled with CFR 0.152.
 */
package omar.projects.interactivestuff.handlers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public final class BackgroundLoopHandler {
    private static final BackgroundLoopHandler INSTANCE = new BackgroundLoopHandler();
    private final Map<String, BackgroundLoop> loops = new ConcurrentHashMap<String, BackgroundLoop>();

    private BackgroundLoopHandler() {
    }

    public static BackgroundLoopHandler getInstance() {
        return INSTANCE;
    }

    public void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) {
                return;
            }
            if (client.method_1493()) {
                return;
            }
            this.loops.values().forEach(BackgroundLoop::tick);
        });
    }

    public void startLoop(String name, Runnable task, int tickDelay) {
        if (this.loops.containsKey(name)) {
            this.endLoop(name);
        }
        this.loops.put(name, new BackgroundLoop(task, tickDelay));
    }

    public void waitTicks(String id, int ticks, Runnable task) {
        if (this.isLoopRunning(id)) {
            return;
        }
        this.startLoop(id, () -> {
            try {
                task.run();
            }
            finally {
                this.endLoop(id);
            }
        }, ticks);
    }

    public void pauseLoop(String name) {
        BackgroundLoop loop = this.loops.get(name);
        if (loop != null) {
            loop.pause();
        }
    }

    public void resumeLoop(String name) {
        BackgroundLoop loop = this.loops.get(name);
        if (loop != null) {
            loop.resume();
        }
    }

    public void endLoop(String name) {
        BackgroundLoop loop = this.loops.remove(name);
        if (loop != null) {
            loop.stop();
        }
    }

    public boolean isLoopRunning(String name) {
        return this.loops.containsKey(name);
    }

    private static final class BackgroundLoop {
        private final Runnable task;
        private final int tickDelay;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final AtomicBoolean paused = new AtomicBoolean(false);
        private int tickCounter = 0;

        private BackgroundLoop(Runnable task, int tickDelay) {
            this.task = task;
            this.tickDelay = tickDelay;
        }

        public void tick() {
            if (!this.running.get() || this.paused.get()) {
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter >= this.tickDelay) {
                this.tickCounter = 0;
                try {
                    this.task.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public void pause() {
            this.paused.set(true);
        }

        public void resume() {
            this.paused.set(false);
        }

        public void stop() {
            this.running.set(false);
        }
    }
}

