/*
 * Decompiled with CFR 0.152.
 */
package omar.projects.interactivestuff.handlers;

import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1113;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_746;
import omar.projects.interactivestuff.handlers.BackgroundLoopHandler;
import omar.projects.interactivestuff.handlers.VibrationTracker;
import omar.projects.interactivestuff.handlers.config.ConfigHandler;

public final class SculkHandler {
    private static boolean wasOnGround;
    private static final double RANGE_NORMAL_SQ = 64.0;
    private static final double RANGE_CALIBRATED_SQ = 256.0;
    private static final int COOLDOWN_NORMAL = 40;
    private static final int COOLDOWN_CALIBRATED = 20;
    private static final Set<class_2960> IGNORED_SOUND_IDS;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(SculkHandler::onTick);
    }

    private static void onTick(class_310 client) {
        if (!ConfigHandler.INSTANCE.enableSculkSensorFeature) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        boolean isOnGround = player.method_24828();
        if (!wasOnGround && isOnGround) {
            SculkHandler.handleLanding(player, client);
        }
        wasOnGround = isOnGround;
    }

    private static void handleLanding(class_746 player, class_310 client) {
        if (player.method_73183().method_8320(player.method_23312()).method_26164(class_3481.field_15481)) {
            return;
        }
        if (player.method_5715()) {
            return;
        }
        SculkHandler.processVibration(player.method_23317(), player.method_23318(), player.method_23321(), client);
    }

    public static void sculkCheck(class_1113 sound) {
        ConfigHandler config = ConfigHandler.INSTANCE;
        if (!config.enableSculkSensorFeature) {
            return;
        }
        if (sound == null) {
            return;
        }
        if (sound.method_4777() == class_1113.class_1114.field_5478) {
            return;
        }
        if (sound.method_4774() == class_3419.field_15256) {
            return;
        }
        if (IGNORED_SOUND_IDS.contains(sound.method_4775())) {
            return;
        }
        SculkHandler.processVibration(sound.method_4784(), sound.method_4779(), sound.method_4778(), class_310.method_1551());
    }

    private static void processVibration(double x, double y, double z, class_310 client) {
        class_746 player = client.field_1724;
        if (player == null || player.method_7325()) {
            return;
        }
        double distanceSq = player.method_5649(x, y, z);
        if (SculkHandler.isHoldingSculkSensor(player)) {
            SculkHandler.handleNormalSensor(client, distanceSq);
        }
        if (SculkHandler.isHoldingCalibratedSculkSensor(player)) {
            SculkHandler.handleCalibratedSensor(client, distanceSq);
        }
    }

    private static boolean isHoldingSculkSensor(class_746 player) {
        return player.method_6047().method_31574(class_1802.field_28101) || player.method_6079().method_31574(class_1802.field_28101);
    }

    private static boolean isHoldingCalibratedSculkSensor(class_746 player) {
        return player.method_6047().method_31574(class_1802.field_43194) || player.method_6079().method_31574(class_1802.field_43194);
    }

    private static void handleNormalSensor(class_310 client, double distanceSq) {
        if (VibrationTracker.isVibrating()) {
            return;
        }
        if (distanceSq > 64.0) {
            return;
        }
        SculkHandler.activateNormal(client);
    }

    private static void handleCalibratedSensor(class_310 client, double distanceSq) {
        if (VibrationTracker.isCalibratedVibrating()) {
            return;
        }
        if (distanceSq > 256.0) {
            return;
        }
        SculkHandler.activateCalibrated(client);
    }

    private static void activateNormal(class_310 client) {
        class_746 player = client.field_1724;
        if (player != null) {
            player.method_5783(class_3417.field_28081, 1.0f, 1.0f);
        }
        VibrationTracker.setVibrating(true);
        BackgroundLoopHandler.getInstance().waitTicks("SculkDeactivateNormal", 40, () -> client.execute(() -> {
            class_746 currentPlayer = client.field_1724;
            if (currentPlayer == null) {
                return;
            }
            if (!VibrationTracker.isVibrating()) {
                return;
            }
            VibrationTracker.setVibrating(false);
            if (SculkHandler.isHoldingSculkSensor(currentPlayer)) {
                currentPlayer.method_5783(class_3417.field_28082, 1.0f, 1.0f);
            }
        }));
    }

    private static void activateCalibrated(class_310 client) {
        class_746 player = client.field_1724;
        if (player != null) {
            player.method_5783(class_3417.field_28081, 1.0f, 1.0f);
        }
        VibrationTracker.setCalibratedVibrating(true);
        BackgroundLoopHandler.getInstance().waitTicks("SculkDeactivateCalibrated", 20, () -> client.execute(() -> {
            class_746 currentPlayer = client.field_1724;
            if (currentPlayer == null) {
                return;
            }
            if (!VibrationTracker.isCalibratedVibrating()) {
                return;
            }
            VibrationTracker.setCalibratedVibrating(false);
            if (SculkHandler.isHoldingCalibratedSculkSensor(currentPlayer)) {
                currentPlayer.method_5783(class_3417.field_28082, 1.0f, 1.0f);
            }
        }));
    }

    static {
        IGNORED_SOUND_IDS = Set.of(class_3417.field_28081.comp_3319(), class_3417.field_28082.comp_3319(), class_3417.field_14983.comp_3319(), class_3417.field_15048.comp_3319(), class_3417.field_14628.comp_3319(), class_3417.field_15181.comp_3319(), class_3417.field_15226.comp_3319());
    }
}

