/*
 * Decompiled with CFR 0.152.
 */
package omar.projects.interactivestuff.handlers.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import omar.projects.interactivestuff.objects.InteractionMaterial;
import org.jetbrains.annotations.NotNull;

public final class ConfigHandler {
    public static ConfigHandler INSTANCE;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    private static final String DEFAULT_CONFIG_PATH = "/assets/interactivestuff/default_config.json";
    public boolean enableInteractiveHits = true;
    public boolean enableSculkSensorFeature = true;
    public boolean enableNoteBlockCrouchFeature = true;
    public boolean enableTextureChanges = true;
    public int HitCooldownTicks = 4;
    @NotNull
    public List<class_1792> excludedBlocks = new ArrayList<class_1792>();
    public List<InteractionMaterial> materials = new ArrayList<InteractionMaterial>();
    private final transient Map<class_1792, InteractionMaterial> itemLookupCache = new HashMap<class_1792, InteractionMaterial>();

    public void reload() {
        ConfigHandler loaded = ConfigHandler.load();
        this.enableInteractiveHits = loaded.enableInteractiveHits;
        this.enableSculkSensorFeature = loaded.enableSculkSensorFeature;
        this.enableNoteBlockCrouchFeature = loaded.enableNoteBlockCrouchFeature;
        this.enableTextureChanges = loaded.enableTextureChanges;
        this.HitCooldownTicks = loaded.HitCooldownTicks;
        this.excludedBlocks = loaded.excludedBlocks;
        this.materials = loaded.materials;
        this.refreshCache();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigHandler load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                ConfigHandler loaded = (ConfigHandler)GSON.fromJson((Reader)reader, ConfigHandler.class);
                if (loaded != null) {
                    loaded.refreshCache();
                    ConfigHandler configHandler = loaded;
                    return configHandler;
                }
            }
            catch (Exception e) {
                System.err.println("[InteractiveStuff] Failed to load user config, falling back to defaults.");
                e.printStackTrace();
            }
        }
        try (InputStream stream = ConfigHandler.class.getResourceAsStream(DEFAULT_CONFIG_PATH);){
            if (stream == null) {
                throw new RuntimeException("Default config not found in jar at: /assets/interactivestuff/default_config.json");
            }
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                ConfigHandler defaults = (ConfigHandler)GSON.fromJson((Reader)reader, ConfigHandler.class);
                if (defaults == null) return new ConfigHandler();
                defaults.save();
                defaults.refreshCache();
                ConfigHandler configHandler = defaults;
                return configHandler;
            }
        }
        catch (Exception e) {
            System.err.println("[InteractiveStuff] CRITICAL: Failed to load default configuration from jar!");
            e.printStackTrace();
        }
        return new ConfigHandler();
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception e) {
            System.err.println("[InteractiveStuff] Failed to save config.");
            e.printStackTrace();
        }
    }

    public void refreshCache() {
        this.itemLookupCache.clear();
        if (this.materials == null) {
            return;
        }
        for (InteractionMaterial material : this.materials) {
            if (material == null || material.items == null) continue;
            for (class_1792 itemId : material.items) {
                if (itemId == null) continue;
                this.itemLookupCache.put(itemId, material);
            }
        }
    }

    public InteractionMaterial getMaterial(class_1792 item) {
        return this.itemLookupCache.get(item);
    }

    public boolean isExcluded(class_2248 block) {
        if (block == null) {
            return false;
        }
        return this.excludedBlocks.contains(block.method_8389());
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(class_1792.class, (src, typeOfSrc, context) -> new JsonPrimitive(class_7923.field_41178.method_10221(src).toString())).registerTypeHierarchyAdapter(class_1792.class, (json, typeOfT, context) -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)json.getAsString()))).create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("interactivestuff.json");
    }
}

