/*
 * Decompiled with CFR 0.152.
 */
package omar.projects.interactivestuff.handlers.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.ItemControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import omar.projects.interactivestuff.handlers.config.ConfigHandler;
import omar.projects.interactivestuff.objects.InteractionMaterial;

public final class ModMenuIntegration
implements ModMenuApi {
    private static final Random random = new Random();

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return this::createConfigScreen;
    }

    private class_437 createConfigScreen(class_437 parent) {
        if (ConfigHandler.INSTANCE == null) {
            ConfigHandler.INSTANCE = ConfigHandler.load();
        }
        ConfigHandler instance = ConfigHandler.INSTANCE;
        ConfigHandler defaults = new ConfigHandler();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43470((String)"InteractiveStuff Config \u00a76\u00a7b(Beta)")).save(instance::save);
        ConfigCategory generalCategory = this.createGeneralCategory(instance, defaults).build();
        builder.category(generalCategory);
        ConfigCategory excludedCategory = this.createExcludedBlocksCategory(instance, defaults).build();
        builder.category(excludedCategory);
        ConfigCategory manageMaterialsCategory = this.createManageMaterialsCategory(instance, defaults).build();
        builder.category(manageMaterialsCategory);
        for (InteractionMaterial mat : instance.materials) {
            InteractionMaterial defaultMat = defaults.materials.stream().filter(m -> m.name.equalsIgnoreCase(mat.name)).findFirst().orElse(null);
            ConfigCategory matCategory = this.createMaterialCategory(mat, defaultMat).build();
            builder.category(matCategory);
        }
        return builder.build().generateScreen(parent);
    }

    private ConfigCategory.Builder createGeneralCategory(ConfigHandler instance, ConfigHandler defaults) {
        ConfigCategory.Builder general = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general")).tooltip(new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.tooltip")});
        general.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.interactive_hits")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.interactive_hits.tooltip")})).binding((Object)defaults.enableInteractiveHits, () -> instance.enableInteractiveHits, newVal -> {
            instance.enableInteractiveHits = newVal;
        }).controller(TickBoxControllerBuilder::create).build());
        general.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.interactive_hits.cooldown")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.interactive_hits.cooldown.tooltip")})).binding((Object)defaults.HitCooldownTicks, () -> instance.HitCooldownTicks, newVal -> {
            instance.HitCooldownTicks = newVal;
        }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)1, (Number)10)).step((Number)1)).build());
        general.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.sculk_sensor")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.sculk_sensor.tooltip")})).binding((Object)defaults.enableSculkSensorFeature, () -> instance.enableSculkSensorFeature, newVal -> {
            instance.enableSculkSensorFeature = newVal;
        }).controller(TickBoxControllerBuilder::create).build());
        general.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.note_block")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.note_block.tooltip")})).binding((Object)defaults.enableNoteBlockCrouchFeature, () -> instance.enableNoteBlockCrouchFeature, newVal -> {
            instance.enableNoteBlockCrouchFeature = newVal;
        }).controller(TickBoxControllerBuilder::create).build());
        general.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.model_changes")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.model_changes.tooltip")})).binding((Object)defaults.enableTextureChanges, () -> instance.enableTextureChanges, newVal -> {
            instance.enableTextureChanges = newVal;
        }).controller(TickBoxControllerBuilder::create).build());
        return general;
    }

    private ConfigCategory.Builder createExcludedBlocksCategory(ConfigHandler instance, ConfigHandler defaults) {
        ConfigCategory.Builder cat = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.excluded_blocks")).tooltip(new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.excluded_blocks.tooltip")});
        cat.option((Option)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.general.excluded_blocks")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.general.excluded_blocks.tooltip")})).binding(defaults.excludedBlocks, () -> instance.excludedBlocks, newVal -> {
            instance.excludedBlocks = newVal;
        }).controller(ItemControllerBuilder::create).initial((Object)class_1802.field_20391).build());
        return cat;
    }

    private ConfigCategory.Builder createManageMaterialsCategory(ConfigHandler instance, ConfigHandler defaults) {
        ConfigCategory.Builder manageMaterials = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.materials")).tooltip(new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.materials.tooltip")});
        manageMaterials.option((Option)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.materials")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.settings.materials.details1").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.materials.details2")).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.materials.details3")).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"interactive_stuff.config.settings.materials.details4"))})).binding(defaults.materials.stream().map(m -> m.name).collect(Collectors.toList()), () -> instance.materials.stream().map(m -> m.name).collect(Collectors.toList()), newList -> {
            instance.materials.removeIf(mat -> !newList.contains(mat.name));
            for (String name : newList) {
                boolean exists = instance.materials.stream().anyMatch(mat -> mat.name.equalsIgnoreCase(name));
                if (exists) continue;
                instance.materials.add(new InteractionMaterial(name));
            }
            instance.materials.sort(Comparator.comparingInt(m -> newList.indexOf(m.name)));
            for (int i = 0; i < instance.materials.size(); ++i) {
                instance.materials.get((int)i).name = (String)newList.get(i);
            }
        }).controller(StringControllerBuilder::create).initial((Object)"").collapsed(false).build());
        return manageMaterials;
    }

    private ConfigCategory.Builder createMaterialCategory(InteractionMaterial mat, InteractionMaterial defaultMat) {
        String displayName = mat.name.isEmpty() ? "?" : mat.name.substring(0, 1).toUpperCase();
        ConfigCategory.Builder matCat = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)displayName)).tooltip(new class_2561[]{class_2561.method_43470((String)mat.name)});
        matCat.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.sound_id")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.sound_id.tooltip")})).binding((Object)(defaultMat != null ? defaultMat.sound : "minecraft:block.stone.break"), () -> mat.sound, newVal -> {
            mat.sound = newVal;
        }).controller(StringControllerBuilder::create).build());
        matCat.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.volume")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.volume.tooltip")})).binding((Object)Float.valueOf(defaultMat != null ? defaultMat.volume : 1.0f), () -> Float.valueOf(mat.volume), newVal -> {
            mat.volume = newVal.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.05f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).build());
        matCat.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.base_pitch")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.base_pitch.tooltip")})).binding((Object)Float.valueOf(defaultMat != null ? defaultMat.pitch : 1.0f), () -> Float.valueOf(mat.pitch), newVal -> {
            mat.pitch = newVal.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.05f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).build());
        matCat.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.random_pitch")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"interactive_stuff.config.random_pitch.tooltip", (Object[])new Object[]{Float.valueOf(mat.pitch)})})).binding((Object)(defaultMat != null && defaultMat.randomPitch ? 1 : 0), () -> mat.randomPitch, newVal -> {
            mat.randomPitch = newVal;
        }).controller(TickBoxControllerBuilder::create).build());
        matCat.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.requires_block_hit")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.requires_block_hit.tooltip")})).binding((Object)(defaultMat == null || defaultMat.requiresBlockHit ? 1 : 0), () -> mat.requiresBlockHit, newVal -> {
            mat.requiresBlockHit = newVal;
        }).controller(TickBoxControllerBuilder::create).build());
        matCat.option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.preview_sound")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.preview_sound.tooltip")})).action((yaclScreen, thisOption) -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)mat.getSoundEvent(), (float)(mat.randomPitch ? mat.pitch + random.nextFloat() * 1.5f : mat.pitch)))).build());
        matCat.option((Option)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.included_items")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.included_items.tooltip")})).binding(defaultMat != null ? defaultMat.items : new ArrayList(), () -> mat.items, newVal -> {
            mat.items = newVal;
        }).controller(ItemControllerBuilder::create).initial((Object)class_1802.field_20391).build());
        ArrayList defaultCustomPitches = defaultMat != null ? defaultMat.customPitches.stream().map(cp -> (cp.item != null ? class_7923.field_41178.method_10221((Object)cp.item).toString() : "minecraft:stone") + "=" + cp.pitch).collect(Collectors.toList()) : new ArrayList();
        matCat.option((Option)ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"interactive_stuff.config.custom_pitches")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"interactive_stuff.config.custom_pitches.tooltip")})).binding(defaultCustomPitches, () -> mat.customPitches.stream().map(cp -> (cp.item != null ? class_7923.field_41178.method_10221((Object)cp.item).toString() : "minecraft:stone") + "=" + cp.pitch).collect(Collectors.toList()), newList -> {
            mat.customPitches.clear();
            for (String entry : newList) {
                String[] split = entry.split("=");
                if (split.length != 2) continue;
                try {
                    class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)split[0]));
                    float pitch = Float.parseFloat(split[1]);
                    mat.customPitches.add(new InteractionMaterial.PitchEntry(item, pitch));
                }
                catch (Exception exception) {}
            }
        }).controller(StringControllerBuilder::create).initial((Object)"minecraft:stone=1.0").collapsed(false).build());
        return matCat;
    }
}

