/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_crossbows.fabric.config;

import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;

public class BetterCrossbowsConfigFabric {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "better_crossbows.toml");
    public static String copperDamage = "5-10";
    public static float copperSpeed = 1.2f;
    public static String goldenDamage = "4-9";
    public static float goldenSpeed = 0.4f;
    public static String diamondDamage = "12-17";
    public static float diamondSpeed = 0.6f;
    public static String netheriteDamage = "20-25";
    public static float netheriteSpeed = 0.4f;

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            BetterCrossbowsConfigFabric.createDefaultConfig();
        } else {
            BetterCrossbowsConfigFabric.loadConfig();
        }
    }

    private static void createDefaultConfig() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(CONFIG_FILE);
            writer.write("#Better Crossbows Configuration File\n\n");
            writer.write("[Crossbow_Copper]\n");
            writer.write("\t#Damage dealt by Copper Crossbow (min-max range, e.g., \"5-10\" means 5 to 10 damage)\n");
            writer.write("\tDamage = \"" + copperDamage + "\"\n");
            writer.write("\t#Charge speed multiplier (lower = faster, 1.0 = normal crossbow speed)\n");
            writer.write("\tSpeed = " + copperSpeed + "\n\n");
            writer.write("[Crossbow_Golden]\n");
            writer.write("\t#Damage dealt by Golden Crossbow (min-max range)\n");
            writer.write("\tDamage = \"" + goldenDamage + "\"\n");
            writer.write("\t#Charge speed multiplier (lower = faster)\n");
            writer.write("\tSpeed = " + goldenSpeed + "\n\n");
            writer.write("[Crossbow_Diamond]\n");
            writer.write("\t#Damage dealt by Diamond Crossbow (min-max range)\n");
            writer.write("\tDamage = \"" + diamondDamage + "\"\n");
            writer.write("\t#Charge speed multiplier (lower = faster)\n");
            writer.write("\tSpeed = " + diamondSpeed + "\n\n");
            writer.write("[Crossbow_Netherite]\n");
            writer.write("\t#Damage dealt by Netherite Crossbow (min-max range)\n");
            writer.write("\tDamage = \"" + netheriteDamage + "\"\n");
            writer.write("\t#Charge speed multiplier (lower = faster)\n");
            writer.write("\tSpeed = " + netheriteSpeed + "\n");
            writer.close();
            System.out.println("Better Crossbows: Created default config file at " + CONFIG_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("Better Crossbows: Failed to create config file!");
            e.printStackTrace();
        }
    }

    private static void loadConfig() {
        try {
            Toml netherite;
            Toml diamond;
            Toml golden;
            Toml toml = new Toml().read(CONFIG_FILE);
            Toml copper = toml.getTable("Crossbow_Copper");
            if (copper != null) {
                copperDamage = copper.getString("Damage", copperDamage);
                copperSpeed = copper.getDouble("Speed", Double.valueOf(copperSpeed)).floatValue();
            }
            if ((golden = toml.getTable("Crossbow_Golden")) != null) {
                goldenDamage = golden.getString("Damage", goldenDamage);
                goldenSpeed = golden.getDouble("Speed", Double.valueOf(goldenSpeed)).floatValue();
            }
            if ((diamond = toml.getTable("Crossbow_Diamond")) != null) {
                diamondDamage = diamond.getString("Damage", diamondDamage);
                diamondSpeed = diamond.getDouble("Speed", Double.valueOf(diamondSpeed)).floatValue();
            }
            if ((netherite = toml.getTable("Crossbow_Netherite")) != null) {
                netheriteDamage = netherite.getString("Damage", netheriteDamage);
                netheriteSpeed = netherite.getDouble("Speed", Double.valueOf(netheriteSpeed)).floatValue();
            }
            System.out.println("Better Crossbows: Loaded config from " + CONFIG_FILE.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Better Crossbows: Failed to load config file, using defaults!");
            e.printStackTrace();
        }
    }
}

