/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.core.block;

import com.tiomadre.farmersassortment.core.block.entity.ButcherBlockCabinetBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class ButcherBlockCabinetBlock
extends CabinetBlock
implements EntityBlock {
    public ButcherBlockCabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        Direction face = hit.m_82434_();
        if (face == Direction.UP) {
            if (!this.isOnCuttingBoard(state, hit)) {
                return InteractionResult.PASS;
            }
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof ButcherBlockCabinetBlockEntity) {
                ButcherBlockCabinetBlockEntity cabinet = (ButcherBlockCabinetBlockEntity)blockEntity2;
                boolean hasBlockAbove = !level.m_46859_(pos.m_7494_());
                ItemStack heldStack = player.m_21120_(hand);
                ItemStack offhandStack = player.m_21206_();
                if (cabinet.isBoardEmpty()) {
                    Item item;
                    if (hasBlockAbove) {
                        return InteractionResult.PASS;
                    }
                    if (player.m_36341_() && !heldStack.m_41619_() && ((item = heldStack.m_41720_()) instanceof TieredItem || item instanceof TridentItem || item instanceof ShearsItem) && cabinet.carveToolOnBoard(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                        level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    if (!offhandStack.m_41619_()) {
                        if (hand == InteractionHand.MAIN_HAND && !offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT) && !(heldStack.m_41720_() instanceof BlockItem)) {
                            if (offhandStack.m_41720_() instanceof BlockItem) {
                                ItemStack offhandStackForBoard;
                                ItemStack itemStack = offhandStackForBoard = player.m_150110_().f_35937_ ? offhandStack.m_41777_() : offhandStack;
                                if (cabinet.addBoardItem(offhandStackForBoard)) {
                                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                                }
                            } else {
                                return InteractionResult.PASS;
                            }
                        }
                        if (hand == InteractionHand.OFF_HAND && offhandStack.m_204117_(ModTags.OFFHAND_EQUIPMENT)) {
                            return InteractionResult.PASS;
                        }
                    }
                    if (heldStack.m_41619_()) {
                        return InteractionResult.SUCCESS;
                    }
                    if (cabinet.addBoardItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                } else {
                    ItemStack removed;
                    if (!heldStack.m_41619_()) {
                        ItemStack boardStack = cabinet.getBoardItem().m_41777_();
                        if (cabinet.processBoardItemUsingTool(heldStack, player)) {
                            ButcherBlockCabinetBlockEntity.spawnCuttingParticles(level, pos, boardStack, 5);
                            return InteractionResult.m_19078_((boolean)level.f_46443_);
                        }
                        return InteractionResult.CONSUME;
                    }
                    if (hand == InteractionHand.MAIN_HAND && !(removed = cabinet.removeBoardItem()).m_41619_()) {
                        if (!player.m_7500_() && !player.m_150109_().m_36054_(removed)) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)removed);
                        }
                        level.m_5594_(null, pos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.25f, 0.5f);
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ButcherBlockCabinetBlockEntity) {
            ButcherBlockCabinetBlockEntity cabinet = (ButcherBlockCabinetBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)cabinet);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        ButcherBlockCabinetBlockEntity cabinet;
        ItemStack storedItem;
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof ButcherBlockCabinetBlockEntity && !(storedItem = (cabinet = (ButcherBlockCabinetBlockEntity)blockEntity).removeBoardItem()).m_41619_()) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)storedItem);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ButcherBlockCabinetBlockEntity) {
            ButcherBlockCabinetBlockEntity cabinet = (ButcherBlockCabinetBlockEntity)blockEntity;
            cabinet.recheckOpen();
        }
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof ButcherBlockCabinetBlockEntity) {
            ButcherBlockCabinetBlockEntity cabinet = (ButcherBlockCabinetBlockEntity)blockEntity;
            cabinet.m_58638_(stack.m_41786_());
        }
    }

    public int m_6782_(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ButcherBlockCabinetBlockEntity) {
            ButcherBlockCabinetBlockEntity cabinet = (ButcherBlockCabinetBlockEntity)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)cabinet);
        }
        return super.m_6782_(state, level, pos);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ButcherBlockCabinetBlockEntity(pos, state);
    }

    private boolean isOnCuttingBoard(BlockState state, BlockHitResult hit) {
        Vec3 localHit = hit.m_82450_().m_82492_((double)hit.m_82425_().m_123341_(), (double)hit.m_82425_().m_123342_(), (double)hit.m_82425_().m_123343_());
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return (switch (facing) {
            case Direction.NORTH -> localHit.f_82481_;
            case Direction.SOUTH -> 1.0 - localHit.f_82481_;
            case Direction.WEST -> localHit.f_82479_;
            case Direction.EAST -> 1.0 - localHit.f_82479_;
            default -> 0.0;
        }) <= 1.0;
    }

    @Mod.EventBusSubscriber(modid="farmersassortment", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ToolCarvingEvent {
        @SubscribeEvent
        public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.m_21205_();
            BlockEntity tileEntity = level.m_7702_(pos);
            if (player.m_36341_() && !heldStack.m_41619_() && tileEntity instanceof ButcherBlockCabinetBlockEntity) {
                boolean success;
                ButcherBlockCabinetBlockEntity cabinet = (ButcherBlockCabinetBlockEntity)tileEntity;
                if ((heldStack.m_41720_() instanceof TieredItem || heldStack.m_41720_() instanceof TridentItem || heldStack.m_41720_() instanceof ShearsItem) && (success = cabinet.carveToolOnBoard(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack))) {
                    level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
    }
}

