/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains;

import net.minecraftforge.common.ForgeConfigSpec;

public class DeadlyBrainsConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.EnumValue<Difficulty> DIFFICULTY_PRESET;
    public static final ForgeConfigSpec.BooleanValue ZOMBIES_BURN;
    public static final ForgeConfigSpec.BooleanValue ALLOW_DAY_SPAWN_IF_NOT_BURNING;
    public static final ForgeConfigSpec.IntValue ZOMBIE_SPAWN_CAP;
    public static final ForgeConfigSpec.IntValue RESPAWN_COOLDOWN_DAY;
    public static final ForgeConfigSpec.IntValue RESPAWN_COOLDOWN_NIGHT;
    public static final ForgeConfigSpec.DoubleValue PATROL_RADIUS;

    static {
        BUILDER.push("General Settings");
        DIFFICULTY_PRESET = BUILDER.comment("Difficulty Preset (Updates other values when changed in GUI)").defineEnum("difficultyPreset", (Enum)Difficulty.NORMAL);
        ZOMBIES_BURN = BUILDER.comment("If TRUE, zombies will burn in sunlight.").define("zombiesBurn", true);
        ALLOW_DAY_SPAWN_IF_NOT_BURNING = BUILDER.comment("Allow day spawn if burning is disabled?").define("allowDaySpawn", true);
        ZOMBIE_SPAWN_CAP = BUILDER.comment("Maximum zombies around player").defineInRange("hordeSize", 30, 5, 500);
        RESPAWN_COOLDOWN_DAY = BUILDER.comment("Seconds between waves (Day)").defineInRange("respawnCooldownDay", 100, 1, 3600);
        RESPAWN_COOLDOWN_NIGHT = BUILDER.comment("Seconds between waves (Night)").defineInRange("respawnCooldownNight", 60, 1, 3600);
        PATROL_RADIUS = BUILDER.comment("Wander radius").defineInRange("patrolRadius", 40.0, 5.0, 256.0);
        BUILDER.pop();
        COMMON_CONFIG = BUILDER.build();
    }

    public static enum Difficulty {
        EASY(15, 180),
        NORMAL(30, 100),
        HARD(60, 40),
        NIGHTMARE(120, 10);

        public final int cap;
        public final int cooldown;

        private Difficulty(int cap, int cooldown) {
            this.cap = cap;
            this.cooldown = cooldown;
        }
    }
}

