/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;

public class ZombieHearingSystem {
    private final Map<Zombie, SoundMemory> memoryMap = new WeakHashMap<Zombie, SoundMemory>();

    public void recordNoise(Zombie listener, Vec3 pos, SoundType type) {
        if (listener == null || !listener.m_6084_()) {
            return;
        }
        long now = listener.m_9236_().m_46467_();
        SoundMemory current = this.memoryMap.get(listener);
        if (current != null) {
            boolean isOld;
            boolean bl = isOld = now - current.timestamp > 200L;
            if (!isOld && current.type.priority > type.priority) {
                return;
            }
        }
        this.memoryMap.put(listener, new SoundMemory(pos, type, now));
    }

    public void onLoudNoise(Zombie listener, Vec3 pos) {
        this.recordNoise(listener, pos, SoundType.MAJOR);
    }

    public Vec3 getNoisePos(Zombie zombie) {
        SoundMemory mem = this.memoryMap.get(zombie);
        if (mem == null) {
            return null;
        }
        if (zombie.m_9236_().m_46467_() - mem.timestamp > 300L) {
            this.memoryMap.remove(zombie);
            return null;
        }
        return mem.pos;
    }

    public void clearNoise(Zombie zombie) {
        this.memoryMap.remove(zombie);
    }

    public boolean hasInterestingNoise(Zombie zombie) {
        return this.getNoisePos(zombie) != null;
    }

    private record SoundMemory(Vec3 pos, SoundType type, long timestamp) {
    }

    public static enum SoundType {
        MINOR(1),
        NORMAL(2),
        MAJOR(3);

        final int priority;

        private SoundType(int p) {
            this.priority = p;
        }
    }
}

