/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai;

import com.j2k.deadlybrains.ai.ZombieHearingSystem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZombieSoundEventHandler {
    private final ZombieHearingSystem hearingSystem;

    public ZombieSoundEventHandler(ZombieHearingSystem hearingSystem) {
        this.hearingSystem = hearingSystem;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.m_7500_()) {
            return;
        }
        this.notifyZombies(player.m_9236_(), Vec3.m_82512_((Vec3i)event.getPos()), 20.0, ZombieHearingSystem.SoundType.MAJOR);
    }

    @SubscribeEvent
    public void onCombatSound(LivingHurtEvent event) {
        Player player;
        Player player2;
        Entity source = event.getSource().m_7639_();
        LivingEntity victim = event.getEntity();
        if (source instanceof Player && !(player2 = (Player)source).m_7500_()) {
            this.notifyZombies(player2.m_9236_(), player2.m_20182_(), 25.0, ZombieHearingSystem.SoundType.MAJOR);
        } else if (victim instanceof Player && !(player = (Player)victim).m_7500_()) {
            this.notifyZombies(player.m_9236_(), player.m_20182_(), 25.0, ZombieHearingSystem.SoundType.MAJOR);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        boolean isNoisyBlock;
        Player player = event.getEntity();
        if (player.m_7500_() || player.m_9236_().f_46443_) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = player.m_9236_().m_8055_(pos);
        if (player.m_6144_()) {
            return;
        }
        boolean bl = isNoisyBlock = state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof TrapDoorBlock || state.m_60734_() instanceof ButtonBlock || state.m_60734_() instanceof LeverBlock || state.m_204336_(BlockTags.f_13095_) || state.m_204336_(BlockTags.f_13055_);
        if (isNoisyBlock) {
            this.notifyZombies(player.m_9236_(), Vec3.m_82512_((Vec3i)pos), 12.0, ZombieHearingSystem.SoundType.NORMAL);
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Player player;
        Projectile projectile = event.getProjectile();
        Entity entity = projectile.m_19749_();
        if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            Vec3 impactPos = event.getRayTraceResult().m_82450_();
            this.notifyZombies(projectile.m_9236_(), impactPos, 10.0, ZombieHearingSystem.SoundType.MINOR);
        }
    }

    private void notifyZombies(Level level, Vec3 pos, double radius, ZombieHearingSystem.SoundType type) {
        List zombies = level.m_45976_(Zombie.class, new AABB(pos.f_82479_ - radius, pos.f_82480_ - radius, pos.f_82481_ - radius, pos.f_82479_ + radius, pos.f_82480_ + radius, pos.f_82481_ + radius));
        for (Zombie z : zombies) {
            this.hearingSystem.recordNoise(z, pos, type);
        }
    }
}

