/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai;

import com.j2k.deadlybrains.DeadlyBrainsConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZombieSpawnHandler {
    private final Random random = new Random();
    private int tickCounter = 0;
    private final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, Vec3> lastAmbushLocation = new HashMap<UUID, Vec3>();

    @SubscribeEvent
    public void onCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.getSpawnType() != MobSpawnType.NATURAL && event.getSpawnType() != MobSpawnType.CHUNK_GENERATION) {
            return;
        }
        BlockPos pos = new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ());
        ServerLevelAccessor level = event.getLevel();
        if (event.getEntity() instanceof Zombie) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (((Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get()).booleanValue() && sl.m_46461_() && sl.m_45527_(pos)) {
                    event.setResult(Event.Result.DENY);
                } else if (!((Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get()).booleanValue() && !((Boolean)DeadlyBrainsConfig.ALLOW_DAY_SPAWN_IF_NOT_BURNING.get()).booleanValue() && sl.m_46461_()) {
                    event.setResult(Event.Result.DENY);
                }
            }
            return;
        }
        if (this.random.nextFloat() < 0.9f) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_) {
            return;
        }
        if (this.tickCounter++ < 10) {
            return;
        }
        this.tickCounter = 0;
        ServerLevel level = (ServerLevel)event.level;
        int targetCap = (Integer)DeadlyBrainsConfig.ZOMBIE_SPAWN_CAP.get();
        long currentTime = level.m_46467_();
        int cdSeconds = level.m_46461_() ? (Integer)DeadlyBrainsConfig.RESPAWN_COOLDOWN_DAY.get() : (Integer)DeadlyBrainsConfig.RESPAWN_COOLDOWN_NIGHT.get();
        long cooldownTicks = (long)cdSeconds * 20L;
        for (Player player : level.m_6907_()) {
            int deficit;
            int toSpawn;
            int spawnedCount;
            long lastWaveEnd;
            Vec3 lastPos;
            if (player.m_5833_() || player.m_7500_()) continue;
            Vec3 currentPos = player.m_20182_();
            if (currentPos.m_82557_(lastPos = this.lastAmbushLocation.getOrDefault(player.m_20148_(), currentPos)) > 1600.0) {
                this.playerCooldowns.remove(player.m_20148_());
                this.lastAmbushLocation.put(player.m_20148_(), currentPos);
            }
            List zombies = level.m_45976_(Zombie.class, player.m_20191_().m_82400_(120.0));
            int count = 0;
            for (Zombie z : zombies) {
                double distSq = z.m_20280_((Entity)player);
                if (distSq > 12100.0) {
                    z.m_146870_();
                    continue;
                }
                ++count;
            }
            if (count >= targetCap || currentTime - (lastWaveEnd = this.playerCooldowns.getOrDefault(player.m_20148_(), 0L).longValue()) < cooldownTicks || count + (spawnedCount = this.spawnBatch(level, player, toSpawn = Math.min(deficit = targetCap - count, 8))) < targetCap) continue;
            this.playerCooldowns.put(player.m_20148_(), currentTime);
            this.lastAmbushLocation.put(player.m_20148_(), currentPos);
        }
    }

    private int spawnBatch(ServerLevel level, Player player, int count) {
        int successCount = 0;
        int attempts = count * 5;
        for (int i = 0; i < attempts && successCount < count; ++i) {
            Zombie zombie;
            BlockPos pos = this.findHiddenSpawnPos(level, player);
            if (pos == null || (zombie = (Zombie)EntityType.f_20501_.m_20615_((Level)level)) == null) continue;
            zombie.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.random.nextFloat() * 360.0f, 0.0f);
            if (this.random.nextFloat() < 0.6f) {
                zombie.m_34336_(true);
            }
            zombie.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.EVENT, null, null);
            if (player.m_20280_((Entity)zombie) < 1600.0) {
                zombie.m_6710_((LivingEntity)player);
            }
            level.m_7967_((Entity)zombie);
            ++successCount;
        }
        return successCount;
    }

    private BlockPos findHiddenSpawnPos(ServerLevel level, Player player) {
        int z;
        int y;
        double minDst = 20.0;
        double maxDst = 55.0;
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        double dist = minDst + this.random.nextDouble() * (maxDst - minDst);
        int x = (int)(player.m_20185_() + Math.cos(angle) * dist);
        BlockPos pos = new BlockPos(x, y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = (int)(player.m_20189_() + Math.sin(angle) * dist)), z);
        if (!level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
            return null;
        }
        if (level.m_8055_(pos).m_60828_((BlockGetter)level, pos)) {
            return null;
        }
        if (level.m_6425_(pos).m_76170_()) {
            return null;
        }
        if (level.m_45517_(LightLayer.BLOCK, pos) > 11) {
            return null;
        }
        if (((Boolean)DeadlyBrainsConfig.ZOMBIES_BURN.get()).booleanValue() && level.m_46461_() && level.m_45527_(pos)) {
            return null;
        }
        Vec3 playerEye = player.m_146892_();
        Vec3 spawnPos = Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 1.5, 0.0);
        Vec3 toSpawn = spawnPos.m_82546_(playerEye).m_82541_();
        Vec3 look = player.m_20154_().m_82541_();
        double dot = look.m_82526_(toSpawn);
        if (dot < -0.3) {
            return pos;
        }
        BlockHitResult hit = level.m_45547_(new ClipContext(playerEye, spawnPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            return pos;
        }
        return null;
    }
}

