/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.deadlybrains.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.phys.Vec3;

public class ZombieSquadManager {
    private static final Map<Zombie, List<Zombie>> squads = new WeakHashMap<Zombie, List<Zombie>>();
    private static final Map<Zombie, SquadRole> roles = new WeakHashMap<Zombie, SquadRole>();

    public static void register(Zombie z) {
        if (!z.m_6084_()) {
            return;
        }
        if (ZombieSquadManager.isLeader(z) && z.f_19797_ % 20 == 0) {
            z.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123765_, z.m_20185_(), z.m_20188_() + 0.8, z.m_20189_(), 0.0, 0.1, 0.0);
        }
        if (roles.containsKey(z)) {
            return;
        }
        List nearby = z.m_9236_().m_45976_(Zombie.class, z.m_20191_().m_82400_(30.0));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((Zombie)z).m_20280_(arg_0)));
        boolean foundSquad = false;
        for (Zombie ally : nearby) {
            if (ally == z || !ally.m_6084_()) continue;
            if (ZombieSquadManager.isLeader(ally)) {
                ZombieSquadManager.joinSquad(ally, z);
                foundSquad = true;
                break;
            }
            for (Map.Entry<Zombie, List<Zombie>> entry : squads.entrySet()) {
                if (!entry.getValue().contains(ally)) continue;
                ZombieSquadManager.joinSquad(entry.getKey(), z);
                foundSquad = true;
                break;
            }
            if (!foundSquad) continue;
            break;
        }
        if (!foundSquad) {
            double chance = z.m_217043_().m_188500_();
            if (chance < 0.15) {
                squads.put(z, new ArrayList());
                roles.put(z, SquadRole.LEADER);
            } else if (chance < 0.35) {
                roles.put(z, SquadRole.ASSASSIN);
            } else if (chance < 0.55) {
                roles.put(z, SquadRole.RUSHER);
            } else if (chance < 0.65) {
                roles.put(z, SquadRole.SCOUT);
            } else {
                roles.put(z, SquadRole.DEFAULT);
            }
        }
    }

    private static void joinSquad(Zombie leader, Zombie recruit) {
        int count;
        List<Zombie> members = squads.get(leader);
        if (members == null) {
            return;
        }
        members.removeIf(z -> !z.m_6084_());
        if (!members.contains(recruit)) {
            members.add(recruit);
        }
        SquadRole role = (count = members.size()) <= 2 ? SquadRole.DEFAULT : (count == 3 ? SquadRole.ASSASSIN : (count == 4 ? SquadRole.RUSHER : (count == 5 ? SquadRole.SCOUT : SquadRole.DEFAULT)));
        roles.put(recruit, role);
    }

    public static Vec3 getTacticalPosition(Zombie z, LivingEntity target) {
        if (target == null) {
            return null;
        }
        SquadRole role = ZombieSquadManager.getRole(z);
        Vec3 tPos = target.m_20182_();
        Vec3 look = target.m_20154_().m_82541_();
        Vec3 right = new Vec3(-look.f_82481_, 0.0, look.f_82479_);
        switch (role) {
            case ASSASSIN: {
                return tPos.m_82549_(look.m_82490_(-4.0));
            }
            case SCOUT: {
                return tPos.m_82549_(right.m_82490_(4.0)).m_82549_(look.m_82490_(-4.0));
            }
            case RUSHER: {
                if (z.f_19797_ % 20 < 10) {
                    return tPos.m_82549_(right.m_82490_(1.5));
                }
                return tPos.m_82549_(right.m_82490_(-1.5));
            }
            case LEADER: {
                return tPos.m_82549_(look.m_82490_(3.0));
            }
        }
        if (z.m_19879_() % 2 == 0) {
            return tPos.m_82549_(right.m_82490_(-6.0)).m_82549_(look.m_82490_(2.0));
        }
        return tPos.m_82549_(right.m_82490_(6.0)).m_82549_(look.m_82490_(2.0));
    }

    public static SquadRole getRole(Zombie z) {
        return roles.getOrDefault(z, SquadRole.DEFAULT);
    }

    public static boolean isLeader(Zombie z) {
        return roles.get(z) == SquadRole.LEADER;
    }

    public static boolean isLoneScout(Zombie z) {
        return ZombieSquadManager.getRole(z) == SquadRole.SCOUT;
    }

    public static void cleanUp() {
        squads.keySet().removeIf(leader -> !leader.m_6084_());
        for (List<Zombie> members : squads.values()) {
            members.removeIf(member -> !member.m_6084_());
        }
        roles.keySet().removeIf(z -> !z.m_6084_());
    }

    public static enum SquadRole {
        LEADER,
        RUSHER,
        ASSASSIN,
        SCOUT,
        DEFAULT;

    }
}

